/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: plg_grants.cpp,v 1.3 2013/09/13 12:53:22 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "plg_grants.h"
#include "grants.h"


PluginGrants::PluginGrants(QObject *parent)
	:QObject(parent), ServicePlugin("grants",
	tr("This plugin allows to control and manage user's accounts"))
{

	Q_INIT_RESOURCE(grants);
	initTranslator(LOCALE_FILE);
}

PluginGrants::~PluginGrants()
{

	/* close all our widgets */
	emit closeWidget();

	Q_CLEANUP_RESOURCE(grants);
}


QWidget *
PluginGrants::create(ServerInfo *info, QWidget *parent)
{
	Grants	*ret;

	ret = new Grants(info, parent);
	connect(this, SIGNAL(closeWidget()), ret, SLOT(deleteNow()));

	return (ret);
}

Q_EXPORT_PLUGIN2(grants, PluginGrants)

/* EOF */
