/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: priv_column.h,v 1.1 2013/09/19 12:40:38 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __PRIV_COLUMN_H__
#define __PRIV_COLUMN_H__

#include "gui.h"
#include "basic_data.h"
#include "priv_item.h"

class PrivColumnItem;
typedef	QVector<PrivColumnItem *>	PrivColumnVector;
typedef	QMap<QString, PrivColumnItem *>	PrivColumnMap;


class PrivColumn:public PrivItem
{
	Q_OBJECT
public:
	PrivColumn(SqlConnection *, QWidget *parent = NULL);
	virtual ~PrivColumn();

	virtual void	timeout(const SqlUser&);
	virtual void	commit(QStringList&)const;
	virtual void	clear();

	virtual bool	isChanged()const;

private:
	PrivColumnVector	vect;
	PrivColumnMap		dmap;
	quint64			crc;

	void	destroyData();
	void	readPrivileges(const SqlUser&);
	void	markAll();
	void	removeMarked();

	PrivColumnItem	*createItem(const QString&);

protected slots:
	virtual void	buttonAction();
};

//-----------------------------------------------------------------------------

class PrivColumnItem:public PrivItem, public BasicData
{
	Q_OBJECT
public:
	PrivColumnItem(const QString&, QWidget *parent = NULL);
	virtual ~PrivColumnItem();

	void	setDefault(sql_privileges_t);
	void	setPrivileges(sql_privileges_t);

	virtual void	timeout(const SqlUser&);
	virtual void	commit(QStringList&)const;
	virtual void	clear();

	virtual bool	isChanged()const;

private:
	Privileges	*priv;

protected slots:
	virtual void	buttonAction();
};

#endif  /* __PRIV_COLUMN_H__ */

/* EOF */
