/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: priv_database.h,v 1.6 2013/09/18 11:29:17 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __PRIV_DATABASE_H__
#define __PRIV_DATABASE_H__

#include "gui.h"
#include "basic_data.h"
#include "priv_item.h"

class PrivDatabaseItem;
typedef	QVector<PrivDatabaseItem *>		PrivDatabaseVector;
typedef	QMap<QString, PrivDatabaseItem *>	PrivDatabaseMap;


class PrivDatabase:public PrivItem
{
	Q_OBJECT
public:
	PrivDatabase(SqlConnection *, QWidget *parent = NULL);
	virtual ~PrivDatabase();

	virtual void	timeout(const SqlUser&);
	virtual void	commit(QStringList&)const;
	virtual void	clear();

	virtual bool	isChanged()const;

private:
	PrivDatabaseVector	vect;
	PrivDatabaseMap		dmap;
	quint64			crc;

	void	destroyData();
	void	readPrivileges(const SqlUser&);
	void	markAll();
	void	removeMarked();

	PrivDatabaseItem	*createItem(const QString&);

protected slots:
	virtual void	buttonAction();
};

//-----------------------------------------------------------------------------

class PrivDatabaseItem:public PrivItem, public BasicData
{
	Q_OBJECT
public:
	PrivDatabaseItem(const QString&, QWidget *parent = NULL);
	virtual ~PrivDatabaseItem();

	void	setDefault(sql_privileges_t);
	void	setPrivileges(sql_privileges_t);

	virtual void	timeout(const SqlUser&);
	virtual void	commit(QStringList&)const;
	virtual void	clear();

	virtual bool	isChanged()const;

private:
	Privileges	*priv;

protected slots:
	virtual void	buttonAction();
};

#endif  /* __PRIV_DATABASE_H__ */

/* EOF */
