/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: priv_global.cpp,v 1.9 2013/09/19 12:40:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "priv_global.h"
#include "sql_user.h"

#define	MY_LEVEL	GrantInfo::G_GLOBAL


PrivGlobal::PrivGlobal(SqlConnection *conn, QWidget *parent)
	:PrivItem(conn, tr("Global (GRANT ON *.*)"), parent), crc(0)
{

	priv = new Privileges(this);
	connect(priv, SIGNAL(changed()), SIGNAL(changed()));
	addWidget(priv);
	priv->setAllowed(PRIV_MASK);
	priv->setDefault(PRIV_USAGE);
	buttonAction();
}

PrivGlobal::~PrivGlobal()
{

	removeWidget(priv);
	delete priv;
}


void
PrivGlobal::timeout(const SqlUser &user)
{
	quint64	tmp = checksum(MY_LEVEL);

	if ((crc != tmp) || (internalUser() != user)) {
		crc = tmp;
		setInternalUser(user);
		readPrivileges(user);
	}
}


void
PrivGlobal::commit(QStringList &queries)const
{

	if (priv->hasChanged()) {
		GrantInfo	info;

		info.type = MY_LEVEL;
		info.user = internalUser().user();
		info.host = internalUser().host();
		GrantInfo::commit(queries, info, priv->defaultPrivileges(),
			priv->privileges());
	}
}


void
PrivGlobal::clear()
{

	setInternalUser(SqlUser());
	priv->setDefault(PRIV_USAGE);
}


bool
PrivGlobal::isChanged()const
{

	return (priv->hasChanged());
}


void
PrivGlobal::buttonAction()
{

	if (priv->isVisible()) {
		priv->hide();
		setButtonType(PrivHeader::BT_PLUS);
	} else {
		priv->show();
		setButtonType(PrivHeader::BT_MINUS);
	}
}


void
PrivGlobal::readPrivileges(const SqlUser &user)
{
	GrantInfo		info;
	SqlPrivilegesFlags	flg, tmp(priv->privileges());
	bool			changed;

	info.type = MY_LEVEL;
	info.host = user.host();
	info.user = user.user();
	flg = privileges(info)["*.*"];
	changed = (tmp != flg);

	if (!changed && priv->hasChanged())
		priv->setDefault(flg);
	else if (!priv->hasChanged()) {
		/* it has not changed by the user */
		if (changed)
			priv->setDefault(flg.flags());
	} else if (changed && question(this)) {
		/* set as default */
		priv->setDefault(flg.flags());
	}
}

/* EOF */
