/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: priv_header.cpp,v 1.3 2013/09/19 12:40:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "priv_header.h"


PrivHeader::PrivHeader(const QString &text, QWidget *parent)
	:QWidget(parent), p_suffix(QString::null), p_text(text)
{
	int	wdt;
	QFont	fnt;

	layout = new QHBoxLayout(this);
	MARGINS_ZERO(layout);

	lab_name = new QLabel(this);
	lab_name->setAutoFillBackground(TRUE);
	lab_name->setBackgroundRole(QPalette::Highlight);
	layout->addWidget(lab_name, 1);
	fnt = lab_name->font();
	fnt.setPointSize(fnt.pointSize() * 10 / 9);
	fnt.setItalic(TRUE);
	lab_name->setFont(fnt);
	wdt = lab_name->fontMetrics().lineSpacing();

	dlg = new QDialogButtonBox(Qt::Horizontal, this);
	layout->addWidget(dlg, 0, Qt::AlignRight);

	btn = new QPushButton(this);
	btn->setMinimumSize(wdt, wdt);
	btn->setMaximumSize(wdt, wdt);
	btn->setFocusPolicy(Qt::NoFocus);
	dlg->addButton(btn, QDialogButtonBox::ActionRole);
	connect(btn, SIGNAL(clicked()), SIGNAL(clicked()));

	setText();
}

PrivHeader::~PrivHeader()
{

	delete btn;
	delete dlg;
	delete lab_name;
	delete layout;
}


void
PrivHeader::setSuffix(const QString &suffix)
{

	p_suffix = suffix;
	setText();
}


void
PrivHeader::setButtonVisible(bool ena)
{

	btn->setVisible(ena);
}


void
PrivHeader::setButtonText(const QString &txt)
{

	btn->setText(txt);
}


void
PrivHeader::setButtonToolTip(const QString &tip)
{

	btn->setToolTip(tip);
}


void
PrivHeader::setButtonType(ButtonType type)
{
	const char	*xpm;

	switch (type) {
		case BT_PLUS:
			xpm = "+";//":/icons/plus.png";
			break;
		case BT_MINUS:
			xpm = "-";//":/icons/minus.png";
			break;
		default:
			abort();
	}

//	btn->setIcon(QIcon(xpm));
	btn->setText(xpm);
}


void
PrivHeader::setText()
{
	QString	txt;

	if (p_suffix.isEmpty())
		txt = QString("  %1").arg(p_text);
	else
		txt = QString("  %1 (%2)").arg(p_text).arg(p_suffix);

	lab_name->setText(txt);
}

/* EOF */
