/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: priv_header.h,v 1.2 2013/09/19 12:40:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __PRIV_HEADER_H__
#define __PRIV_HEADER_H__

#include "gui.h"


class PrivHeader:public QWidget
{
	Q_OBJECT
public:
	enum ButtonType {
		BT_PLUS,
		BT_MINUS
	};
	PrivHeader(const QString&, QWidget *parent = NULL);
	~PrivHeader();

	void	setSuffix(const QString&);

private:
	QString			p_suffix, p_text;
	QHBoxLayout		*layout;
	QLabel			*lab_name;
	QDialogButtonBox	*dlg;
	QPushButton		*btn;

	void	setText();

public slots:
	void	setButtonVisible(bool);
	void	setButtonText(const QString&);
	void	setButtonToolTip(const QString&);
	void	setButtonType(ButtonType);

signals:
	void	clicked();
};

#endif  /* __PRIV_ITEM_H__ */

/* EOF */
