/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: priv_item.cpp,v 1.6 2013/09/19 12:40:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "priv_item.h"
#include "privileges.h"
#include "sql_user.h"


PrivItem::PrivItem(SqlConnection *conn, const QString &text, QWidget *parent)
	:QGroupBox(parent), p_level(text), p_conn(conn)
{

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	hdr = new PrivHeader(text, this);
	connect(hdr, SIGNAL(clicked()), this, SLOT(buttonAction()));
	hdr->setButtonType(PrivHeader::BT_PLUS);
	layout->addWidget(hdr, 0, Qt::AlignTop);
}


PrivItem::~PrivItem()
{

	delete hdr;
	delete layout;
}


void
PrivItem::timeout(const SqlUser &user)
{

	cout<<user<<endl;
}


QString
PrivItem::level()const
{

	return (p_level);
}


void
PrivItem::addWidget(QWidget *win)
{

	layout->addWidget(win, 0, Qt::AlignTop);
}


void
PrivItem::removeWidget(QWidget *win)
{

	layout->removeWidget(win);
}


void
PrivItem::setInternalUser(const SqlUser &user)
{

	old_user = user;
}


void
PrivItem::addHeader(const QString &add)
{

	hdr->setSuffix(add);
}


SqlUser
PrivItem::internalUser()const
{

	return (old_user);
}


SqlPrivilegesMap
PrivItem::privileges(const GrantInfo &info)const
{

	return (p_conn->privileges(info));
}


quint64
PrivItem::checksum(GrantInfo::Type type)const
{

	return (p_conn->checksum(type));
}


void
PrivItem::buttonAction()
{

	Core::notImplemented(this);
}


void
PrivItem::setButtonType(PrivHeader::ButtonType type)
{

	hdr->setButtonType(type);
}


bool
PrivItem::question(QWidget *parent)const
{
	QMessageBox::StandardButton	res;

	res = QMessageBox::question(parent, tr("Privileges changed"),
		tr("Another database administrator "
		"changed privileges for current account.\n"
		"Do you want to load it or to ignore?"),
		QMessageBox::Yes | QMessageBox::Ignore, QMessageBox::Yes);

	return (res == QMessageBox::Yes);
}

/* EOF */
