/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: priv_item.h,v 1.6 2013/09/19 12:40:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __PRIV_ITEM_H__
#define __PRIV_ITEM_H__

#include "gui.h"
#include "sql_user.h"
#include "priv_header.h"
#include "privileges.h"
#include "sql_connection.h"

class SqlUser;

class PrivItem:public QGroupBox
{
	Q_OBJECT
public:
	PrivItem(SqlConnection *, const QString&, QWidget *parent = NULL);
	virtual ~PrivItem();

	virtual void	timeout(const SqlUser&);
	virtual void	commit(QStringList&)const = 0;
	virtual void	clear() = 0;

	virtual bool	isChanged()const = 0;

	QString	level()const;

private:
	QString		p_level;
	SqlUser		old_user;
	QVBoxLayout	*layout;
	PrivHeader	*hdr;
	SqlConnection	*p_conn;

protected:
	void	addWidget(QWidget *);
	void	removeWidget(QWidget *);
	void	setInternalUser(const SqlUser&);
	void	addHeader(const QString&);

	bool			question(QWidget *parent = NULL)const;
	SqlUser			internalUser()const;
	SqlPrivilegesMap	privileges(const GrantInfo&)const;
	quint64			checksum(GrantInfo::Type)const;

public slots:
	void	setButtonType(PrivHeader::ButtonType);

protected slots:
	virtual void	buttonAction();

signals:
	void	changed();
};

#endif  /* __PRIV_ITEM_H__ */

/* EOF */
