/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: priv_proc_dialog.cpp,v 1.1 2013/09/19 12:40:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "priv_proc_dialog.h"
#include "privileges.h"

#define	BUTTON_SAVE	QDialogButtonBox::Save
#define	BUTTONS		(BUTTON_SAVE | QDialogButtonBox::Cancel)


PrivProcDialog::PrivProcDialog(QWidget *parent)
	:QDialog(parent)
{

	setWindowTitle(Core::text(Core::NewObjectPrivileges));

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	form = new QFormLayout();
	layout->addLayout(form);
	MARGINS_ZERO(form);

	dbEdit = new QLineEdit(this);
	dbEdit->setMaxLength(64);
	form->addRow(tr("Specify a database"), dbEdit);

	rtEdit = new QLineEdit(this);
	rtEdit->setMaxLength(64);
	form->addRow(tr("Specify a routine"), rtEdit);

	rtType = new QComboBox(this);
	rtType->addItems(QStringList()<<Core::text(Core::Procedure)
		<<Core::text(Core::Function));
	form->addRow(tr("Type of the routine"), rtType);

	priv = new Privileges(this);
	connect(priv, SIGNAL(changed()), this, SLOT(privChanged()));
	priv->setAllowed(PRIV_PROC_MASK);
	form->addRow(priv);

	dlg = new QDialogButtonBox(BUTTONS, Qt::Horizontal, this);
	connect(dlg, SIGNAL(accepted()), this, SLOT(accept()));
	connect(dlg, SIGNAL(rejected()), this, SLOT(reject()));
	layout->addWidget(dlg, 0, Qt::AlignBottom);

	connect(dbEdit, SIGNAL(textChanged(const QString&)),
		this, SLOT(setLevel(const QString&)));
	connect(rtEdit, SIGNAL(textChanged(const QString&)),
		this, SLOT(setLevel(const QString&)));

	setLevel(QString::null);
}

PrivProcDialog::~PrivProcDialog()
{

	delete dlg;
	delete priv;
	delete rtType;
	delete rtEdit;
	delete dbEdit;
	delete form;
	delete layout;
}


void
PrivProcDialog::setLevel(const QString&)
{
	QString	db(dbEdit->text()),
		rt(rtEdit->text());

	priv->setTitle(QString("Grant ON %1.%2").arg(db).arg(rt));
	privChanged();
}


QString
PrivProcDialog::database()const
{

	return (dbEdit->text());
}


QString
PrivProcDialog::routine()const
{

	return (rtEdit->text());
}


SqlPrivilegesFlags::ProcType
PrivProcDialog::type()const
{
	SqlPrivilegesFlags::ProcType	ret = SqlPrivilegesFlags::P_NONE;

	switch (rtType->currentIndex()) {
		case 0:
			ret = SqlPrivilegesFlags::P_PROC;
			break;
		case 1:
			ret = SqlPrivilegesFlags::P_FUNC;
			break;
		default:
			abort();
	}

	return (ret);
}


SqlPrivilegesFlags
PrivProcDialog::privileges()const
{

	return (priv->privileges());
}


void
PrivProcDialog::privChanged()
{
	QString	db(dbEdit->text()),
		rt(rtEdit->text());

	setAcceptEnabled(!db.isEmpty() & !rt.isEmpty() & priv->hasChanged());
}


void
PrivProcDialog::setAcceptEnabled(bool ena)
{
	QPushButton	*btn = dlg->button(BUTTON_SAVE);

	if (btn != NULL)
		btn->setEnabled(ena);
}

/* EOF */
