/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: priv_proxy.cpp,v 1.2 2013/09/19 12:57:08 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "priv_proxy.h"
//#include "priv_proc_dialog.h"

#define	MY_LEVEL	GrantInfo::G_PROXY


PrivProxy::PrivProxy(SqlConnection *conn, QWidget *parent)
	:PrivItem(conn, tr("Proxies accounts"), parent),
	crc(0)
{

}

PrivProxy::~PrivProxy()
{

	destroyData();
}


void
PrivProxy::timeout(const SqlUser &)
{
#if	0
	quint64	tmp = checksum(MY_LEVEL);
	bool	changed = (internalUser() != user);

	if ((crc != tmp) || changed) {
		crc = tmp;
		setInternalUser(user);
		if (changed)
			destroyData();
		readPrivileges(user);
	}
#endif
}


void
PrivProxy::commit(QStringList &queries)const
{
	PrivProxyVector::const_iterator	it;

	for (it = vect.constBegin(); it != vect.constEnd(); ++it)
		(*it)->commit(queries);
}


void
PrivProxy::clear()
{

	setInternalUser(SqlUser());
	destroyData();
}


bool
PrivProxy::isChanged()const
{
	PrivProxyVector::const_iterator	it;
	bool				ret = FALSE;

	for (it = vect.constBegin(); it != vect.constEnd(); ++it) {
		ret |= (*it)->isChanged();
		if (ret != FALSE)
			break;
	}

	return (ret);
}


void
PrivProxy::destroyData()
{
	PrivProxyVector::iterator	it;
	PrivProxyItem			*ptr;

	for (it = vect.begin(); it != vect.end(); ++it) {
		ptr = *it;
		removeWidget(ptr);
		delete ptr;
	}
	vect.clear();
	dmap.clear();
}


void
PrivProxy::buttonAction()
{
#if	0
	PrivProxyDialog	*dlg;
	PrivProxyItem	*item;

	dlg = new PrivProcDialog(this);
	if (dlg->exec()) {
		QString	level(QString("%1.%2").arg(dlg->database())
				.arg(dlg->routine()));

		item = dmap.value(level, NULL);
		if (item == NULL)
			item = createItem(level, dlg->type());
		item->setPrivileges(dlg->privileges());
		item->timeout(internalUser());
	}
	delete dlg;
#endif
	QMessageBox::information(this, tr("Oops ;-)"),
		tr("You hit the features that we have never used.\n"
		"Do you think we should release it for you?\n"
		"Send an E-mail to us and maybe we will do it. ;-)\n"
		"Don't forget the keyword: MAYBE ;-)"));
}


void
PrivProxy::readPrivileges(const SqlUser &user)
{
	GrantInfo			info;
	SqlPrivilegesMap		map;
	SqlPrivilegesMap::iterator	it;
	QString				level;
	SqlPrivilegesFlags		flags;
	PrivProxyItem			*item;

	info.type = MY_LEVEL;
	info.host = user.host();
	info.user = user.user();
	map = privileges(info);

	markAll();

	for (it = map.begin(); it != map.end(); ++it) {
		level = it.key();
		flags = it.value();
		item = dmap.value(level, NULL);
		if (item == NULL) {
			item = createItem(level);
			item->setDefault(flags);
			item->timeout(user);
		} else {
			item->setMarked(FALSE);
			item->setDefault(flags.flags());
		}
	}

	removeMarked();
}


void
PrivProxy::markAll()
{
	PrivProxyVector::iterator	it;

	for (it = vect.begin(); it != vect.end(); ++it)
		(*it)->setMarked(TRUE);
}


void
PrivProxy::removeMarked()
{
	PrivProxyVector::iterator	it;
	PrivProxyItem			*item;
	QString				level;
	int				ch = 0;

	for (it = vect.begin(); it != vect.end(); ) {
		item = *it;
		if (item->isMarked()) {
			dmap.remove(item->level());
			it = vect.erase(it);
			removeWidget(item);
			delete item;
			++ch;
		} else
			++it;
	}

	if (ch > 0)
		emit changed();
}


PrivProxyItem *
PrivProxy::createItem(const QString &level)
{
	PrivProxyItem	*ret;

	ret = new PrivProxyItem(level, this);
	connect(ret, SIGNAL(changed()), SIGNAL(changed()));
	vect.append(ret);
	dmap[level] = ret;
	addWidget(ret);

	return (ret);
}

//-----------------------------------------------------------------------------

PrivProxyItem::PrivProxyItem(const QString &item, QWidget *parent)
	:PrivItem(NULL, item, parent), BasicData()
{

	priv = new Privileges(this);
	connect(priv, SIGNAL(changed()), SIGNAL(changed()));
//	priv->setAllowed(PRIV_PROXY_MASK);
	priv->setDefault(PRIV_USAGE);
	addWidget(priv);
	priv->hide();
}

PrivProxyItem::~PrivProxyItem()
{

	delete priv;
}


void
PrivProxyItem::setDefault(sql_privileges_t flags)
{
	sql_privileges_t	tmp = priv->privileges();
	bool			changed = (tmp != flags);

	if (!changed && priv->hasChanged())
		priv->setDefault(flags);
	else if (!priv->hasChanged()) {
		/* it has not changed by the user */
		if (changed)
			priv->setDefault(flags);
	} else if (changed && question(this)) {
		/* set as default */
		priv->setDefault(flags);
	}
}


void
PrivProxyItem::setPrivileges(sql_privileges_t flags)
{

	priv->setPrivileges(flags);
}


void
PrivProxyItem::timeout(const SqlUser &user)
{

	setInternalUser(user);
}


void
PrivProxyItem::commit(QStringList &/*queries*/)const
{

	if (priv->hasChanged()) {
		GrantInfo	info;
		QStringList	list(level().split('.',
					QString::SkipEmptyParts));

		info.type = MY_LEVEL;
		info.user = internalUser().user();
		info.host = internalUser().host();
		/*GrantInfo::commit(queries, info, priv->defaultPrivileges(),
			priv->privileges());*/
	}
}


void
PrivProxyItem::clear()
{

	/* nothing to do here */
}


void
PrivProxyItem::buttonAction()
{

	if (priv->isVisible()) {
		priv->hide();
		setButtonType(PrivHeader::BT_PLUS);
	} else {
		priv->show();
		setButtonType(PrivHeader::BT_MINUS);
	}
}


bool
PrivProxyItem::isChanged()const
{

	return (priv->hasChanged());
}

/* EOF */
