/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: priv_table_dialog.cpp,v 1.1 2013/09/18 11:29:17 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "priv_table_dialog.h"
#include "privileges.h"

#define	BUTTON_SAVE	QDialogButtonBox::Save
#define	BUTTONS		(BUTTON_SAVE | QDialogButtonBox::Cancel)


PrivTableDialog::PrivTableDialog(QWidget *parent)
	:QDialog(parent)
{

	setWindowTitle(Core::text(Core::NewObjectPrivileges));

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	form = new QFormLayout();
	layout->addLayout(form);
	MARGINS_ZERO(form);

	dbEdit = new QLineEdit(this);
	dbEdit->setMaxLength(64);
	form->addRow(tr("Specify a database"), dbEdit);

	tblEdit = new QLineEdit(this);
	tblEdit->setMaxLength(64);
	form->addRow(tr("Specify a table"), tblEdit);

	priv = new Privileges(this);
	connect(priv, SIGNAL(changed()), this, SLOT(privChanged()));
	priv->setAllowed(PRIV_TABLE_MASK);
	form->addRow(priv);

	dlg = new QDialogButtonBox(BUTTONS, Qt::Horizontal, this);
	connect(dlg, SIGNAL(accepted()), this, SLOT(accept()));
	connect(dlg, SIGNAL(rejected()), this, SLOT(reject()));
	layout->addWidget(dlg, 0, Qt::AlignBottom);

	connect(dbEdit, SIGNAL(textChanged(const QString&)),
		this, SLOT(setLevel(const QString&)));
	connect(tblEdit, SIGNAL(textChanged(const QString&)),
		this, SLOT(setLevel(const QString&)));

	setLevel(QString::null);
}

PrivTableDialog::~PrivTableDialog()
{

	delete dlg;
	delete priv;
	delete tblEdit;
	delete dbEdit;
	delete form;
	delete layout;
}


void
PrivTableDialog::setLevel(const QString&)
{
	QString	db(dbEdit->text()),
		tbl(tblEdit->text());

	priv->setTitle(QString("Grant ON %1.%2").arg(db).arg(tbl));
	privChanged();
}


QString
PrivTableDialog::database()const
{

	return (dbEdit->text());
}


QString
PrivTableDialog::table()const
{

	return (tblEdit->text());
}


SqlPrivilegesFlags
PrivTableDialog::privileges()const
{

	return (priv->privileges());
}


void
PrivTableDialog::privChanged()
{
	QString	db(dbEdit->text()),
		tbl(tblEdit->text());

	setAcceptEnabled(!db.isEmpty() & !tbl.isEmpty() & priv->hasChanged());
}


void
PrivTableDialog::setAcceptEnabled(bool ena)
{
	QPushButton	*btn = dlg->button(BUTTON_SAVE);

	if (btn != NULL)
		btn->setEnabled(ena);
}

/* EOF */
