/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: priv_table_dialog.h,v 1.1 2013/09/18 11:29:17 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __PRIV_TABLE_DIALOG_H__
#define __PRIV_TABLE_DIALOG_H__

#include "gui.h"
#include "sql_privileges_flags.h"

#define	PRIV_TABLE_MASK	(PRIV_SELECT | PRIV_INSERT | PRIV_UPDATE |	\
	PRIV_DELETE | PRIV_CREATE | PRIV_DROP | PRIV_GRANT |		\
	PRIV_REFERENCES | PRIV_INDEX | PRIV_ALTER | PRIV_CREATE_VIEW |	\
	PRIV_SHOW_VIEW | PRIV_TRIGGER)


class Privileges;

class PrivTableDialog:public QDialog
{
	Q_OBJECT
public:
	PrivTableDialog(QWidget *parent = NULL);
	~PrivTableDialog();

	QString			database()const;
	QString			table()const;
	SqlPrivilegesFlags	privileges()const;

private:
	QVBoxLayout		*layout;
	QFormLayout		*form;
	QLineEdit		*dbEdit;
	QLineEdit		*tblEdit;
	Privileges		*priv;
	QDialogButtonBox	*dlg;

	void	setAcceptEnabled(bool);

private slots:
	void	setLevel(const QString&);
	void	privChanged();
};

#endif  /* __PRIV_TABLE_DIALOG_H__ */

/* EOF */
