/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: privileges.h,v 1.5 2013/09/18 11:29:17 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __PRIVILEGES_H__
#define __PRIVILEGES_H__

#include "gui.h"
#include "sql_privileges_flags.h"


class Privileges:public QGroupBox
{
	Q_OBJECT
public:
	Privileges(QWidget *parent = NULL);
	~Privileges();

	void	setAllowed(sql_privileges_t);
	void	setDefault(sql_privileges_t);
	void	setPrivileges(sql_privileges_t);

	SqlPrivilegesFlags	privileges()const;
	SqlPrivilegesFlags	defaultPrivileges()const;
	bool			hasChanged()const;

private:
	SqlPrivilegesFlags	p_allowed;	/* allowed privileges */
	SqlPrivilegesFlags	p_default;	/* default privileges */
	QVBoxLayout		*layout;
	QGridLayout		*grid;
	QDialogButtonBox	*dlg;
	QPushButton		*setAll;
	QPushButton		*unsetAll;
	QPushButton		*revert;
	QCheckBox		*p_sel, *p_ins, *p_upd, *p_del;
	QCheckBox		*p_crt, *p_drp, *p_rel, *p_shd;
	QCheckBox		*p_pro, *p_fil, *p_grt, *p_ref;
	QCheckBox		*p_ndx, *p_alt, *p_sdb, *p_sup;
	QCheckBox		*p_ctt, *p_ltb, *p_exe, *p_rps;
	QCheckBox		*p_rpc, *p_crv, *p_shv, *p_crr;
	QCheckBox		*p_alr, *p_cru, *p_evt, *p_trg;
	QCheckBox		*p_cts;

	void	initRows();
	void	initRow1(int&);
	void	initRow2(int&);
	void	initRow3(int&);
	void	initRow4(int&);
	void	initRow5(int&);
	void	initRow6(int&);
	void	initRow7(int&);
	void	initRow8(int&);
	void	setData(const SqlPrivilegesFlags&);

private slots:
	void	grantAll();
	void	revokeAll();
	void	revertPrivileges();
	void	privChanged(int);

signals:
	void	changed();
};

#endif  /* __PRIVILEGES_H__ */

/* EOF */
