/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: privileges_widget.cpp,v 1.4 2013/09/16 11:42:47 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "privileges_widget.h"
#include "privileges.h"

#define	ICON_PLUS	":/icons/plus.png"
#define	ICON_MINUS	":/icons/minus.png"


PrivilegesWidget::PrivilegesWidget(const QString &level, QWidget *parent)
	:QGroupBox(parent)
{
	int	wdt;
	QFont	fnt;

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	hbox = new QHBoxLayout();
	MARGINS_ZERO(hbox);
	layout->addLayout(hbox);

	p_level = new QLabel(QString("  %1").arg(level), this);
	wdt = p_level->fontMetrics().lineSpacing();
	fnt = p_level->font();
	fnt.setBold(TRUE); fnt.setItalic(TRUE);
	p_level->setFont(fnt);
	p_level->setAutoFillBackground(TRUE);
	p_level->setBackgroundRole(QPalette::Dark);
	hbox->addWidget(p_level, 1);

	shbtn = new QPushButton(this);
	connect(shbtn, SIGNAL(clicked()), this, SLOT(shPrivileges()));
	shbtn->setIcon(QIcon(ICON_MINUS));
	shbtn->setMaximumSize(wdt, wdt);
	shbtn->setFocusPolicy(Qt::NoFocus);
	hbox->addWidget(shbtn, 0, Qt::AlignRight);

	p_priv = new Privileges(this);
	layout->addWidget(p_priv, 1);
}

PrivilegesWidget::~PrivilegesWidget()
{

	delete p_priv;
	delete shbtn;
	delete p_level;
	delete hbox;
	delete layout;
}


/* Called by clicked to the `shbtn` button to show/hide privileges box */
void
PrivilegesWidget::shPrivileges()
{
	bool	sh = p_priv->isVisible() ^ TRUE;

	p_priv->setVisible(sh);
	shbtn->setIcon(QIcon(sh?ICON_MINUS:ICON_PLUS));
}


void
PrivilegesWidget::setAllowedLevel(GrantInfo::Type level)
{
	sql_privileges_t	flags;

	switch (level) {
		case GrantInfo::G_GLOBAL:
			flags = PRIV_MASK;	/* select all flags */
			break;
		default:
			flags = 0;
			break;
	}
	p_priv->setAllowed(flags);
}

/* EOF */
