/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: resource_control.cpp,v 1.5 2013/09/03 10:28:30 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "resource_control.h"
#include "user.h"


ResourceControl::ResourceControl(QWidget *parent)
	:QGroupBox(parent)
{
	int	max = INT_MAX;
	QString	special(Core::text(Core::Unlimited));

	layout = new QFormLayout(this);
	MARGINS_ZERO(layout);

	maxQ = new QSpinBox(this);
	maxQ->setRange(0, max);
	maxQ->setSpecialValueText(special);
	layout->addRow(tr("Number of statements per hour"), maxQ);

	maxU = new QSpinBox(this);
	maxU->setRange(0, max);
	maxU->setSpecialValueText(special);
	layout->addRow(tr("Number of updates per hour"), maxU);

	maxC = new QSpinBox(this);
	maxC->setRange(0, max);
	maxC->setSpecialValueText(special);
	layout->addRow(tr("Number of connections per hour"), maxC);

	maxUC = new QSpinBox(this);
	maxUC->setRange(0, max);
	maxUC->setSpecialValueText(tr("depends of max_connections"));
	layout->addRow(tr("Number of simultaneous connections for "
		"this account"), maxUC);
}

ResourceControl::~ResourceControl()
{

	delete maxUC;
	delete maxC;
	delete maxU;
	delete maxQ;
	delete layout;
}


void
ResourceControl::getData(User &usr)const
{

	usr.setMaxQuestions(maxQ->value());
	usr.setMaxUpdates(maxU->value());
	usr.setMaxConnections(maxC->value());
	usr.setMaxUserConnections(maxUC->value());
}


void
ResourceControl::setData(const User &usr)
{

	maxQ->setValue(usr.maxQuestions());
	maxU->setValue(usr.maxUpdates());
	maxC->setValue(usr.maxConnections());
	maxUC->setValue(usr.maxUserConnections());
}

/* EOF */
