/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: ssl_control.cpp,v 1.6 2013/09/03 10:28:30 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "ssl_control.h"
#include "user.h"


SslControl::SslControl(QWidget *parent)
	:QGroupBox(parent)
{
	QString	x509(tr("The account must use SSL and must have a "
			"valid X509 certificate."));

	layout = new QFormLayout(this);
	MARGINS_ZERO(layout);

	x509Edit = new QCheckBox(tr("The account must have a valid "
		"X509 certificate"), this);
	connect(x509Edit, SIGNAL(clicked(bool)),
		this, SLOT(setX509(bool)));
	layout->addRow(x509Edit);

	subjEdit = new QLineEdit(this);
	subjEdit->setToolTip(tr("%1\nAlso, the certificate's Subject "
		"must be the one specified via this string").arg(x509));
	layout->addRow(tr("Ceritificate's subject"), subjEdit);

	issuerEdit = new QLineEdit(this);
	issuerEdit->setToolTip(tr("%1\nAlso, the Certificate Authority "
		"must be the one specified via this string").arg(x509));
	layout->addRow(tr("Certificate Authority"), issuerEdit);

	cipherEdit = new QLineEdit(this);
	cipherEdit->setToolTip(tr("%1\nAlso, the encription used for the "
		"connection must use one of the methods specified in this "
		"string").arg(x509));
	layout->addRow(tr("Encryption methods"), cipherEdit);

	setX509(x509Edit->isChecked());
}

SslControl::~SslControl()
{

	delete cipherEdit;
	delete issuerEdit;
	delete subjEdit;
	delete x509Edit;
	delete layout;
}


void
SslControl::getData(User &usr)
{

	if (x509Edit->isChecked())
		usr.setSslType(User::SSL_X509);
	else {
		QString	cipher(cipherEdit->text()),
			issuer(issuerEdit->text()),
			subject(subjEdit->text());
		if (cipher.isEmpty() && issuer.isEmpty() && subject.isEmpty())
			usr.setSslType(User::SSL_ANY);	/* any */
		else {
			/* specified */
			usr.setSslType(User::SSL_SPEC);
			usr.setCipher(cipher);
			usr.setX509Issuer(issuer);
			usr.setX509Subject(subject);
		}
	}
}


void
SslControl::setData(const User &usr)
{
	User::SslType	t = usr.sslType();

	x509Edit->setChecked(t == User::SSL_X509);
	switch (t) {
		case User::SSL_SPEC:
			cipherEdit->setText(usr.cipher());
			issuerEdit->setText(usr.x509Issuer());
			subjEdit->setText(usr.x509Subject());
			break;
		default:
			setX509(x509Edit->isChecked());
			break;
			
	}
}


void
SslControl::setX509(bool x509)
{

	subjEdit->clear();
	subjEdit->setDisabled(x509);
	issuerEdit->clear();
	issuerEdit->setDisabled(x509);
	cipherEdit->clear();
	cipherEdit->setDisabled(x509);
}

/* EOF */
