/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: ssl_control.h,v 1.6 2013/09/03 10:28:30 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __SSL_CONTROL_H__
#define __SSL_CONTROL_H__

#include "gui.h"

class User;

class SslControl:public QGroupBox
{
	Q_OBJECT
public:
	SslControl(QWidget *parent = NULL);
	~SslControl();

	void	getData(User&);
	void	setData(const User&);

private:
	QFormLayout	*layout;
	QCheckBox	*x509Edit;	/* user.ssl_type == X509 */
	QLineEdit	*subjEdit;	/* user.ssl_cipher */
	QLineEdit	*issuerEdit;	/* user.x509_issuer */
	QLineEdit	*cipherEdit;	/* user.x509_subject */

private slots:
	void	setX509(bool);
};

#endif  /* __SSL_CONTROL_H__ */

/* EOF */
