/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: user.h,v 1.3 2013/09/03 10:28:30 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __USER_H__
#define __USER_H__

#include "sql_user.h"
#include "basic_data.h"

class User;
class SqlConnection;
class SqlError;
typedef	QVector<User *>		UserVector;
typedef	QMap<QString, User *>	UserMap;


class User:public SqlUser, public BasicData
{
public:
	enum SslType {
		SSL_NONE,
		SSL_ANY,
		SSL_X509,
		SSL_SPEC
	};

	User();
	User(const User&);
	~User();

	void	setUser(const User&);
	void	setUser(const QString&);
	void	setSslType(SslType);
	void	setSslType(const QString&);
	void	setCipher(const QString&);
	void	setX509Issuer(const QString&);
	void	setX509Subject(const QString&);
	void	setMaxQuestions(quint64);
	void	setMaxUpdates(quint64);
	void	setMaxConnections(quint64);
	void	setMaxUserConnections(qint64);
	void	create(SqlConnection *, SqlError&)const;
	void	grant(SqlConnection *, SqlError&,
			const User &old = User())const;

	SslType	sslType()const;
	QString	cipher()const;
	QString	x509Issuer()const;
	QString	x509Subject()const;
	quint64	maxQuestions()const;
	quint64	maxUpdates()const;
	quint64	maxConnections()const;
	qint64	maxUserConnections()const;

	static QString	type2str(SslType);
	static SslType	str2type(const QString&);

private:
	SslType	p_ssl;
	QString	p_cipher;
	QString	p_x509_issuer;
	QString	p_x509_subject;
	quint64	p_mq;
	quint64	p_mu;
	quint64	p_mc;
	qint64	p_muc;
	/* FIXME: plugin, authentication_string */
};

#endif  /* __USER_H__ */

/* EOF */
