/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: user_dialog.cpp,v 1.6 2013/09/03 10:28:30 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "user_dialog.h"

#define	BUTTON_SAVE	QDialogButtonBox::Save
#define	BUTTONS		(BUTTON_SAVE | QDialogButtonBox::Cancel)


UserDialog::UserDialog(QWidget *parent)
	:QDialog(parent)
{

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	form = new QFormLayout();
	layout->addLayout(form, 1);

	labAccount = new QLabel(this);
	form->addRow(tr("SQL account"), labAccount);

	userEdit = new QLineEdit(this);
	connect(userEdit, SIGNAL(textChanged(const QString&)),
		this, SLOT(showAccount(const QString&)));
	form->addRow(tr("User name"), userEdit);

	hostEdit = new QLineEdit(this);
	connect(hostEdit, SIGNAL(textChanged(const QString&)),
		this, SLOT(showAccount(const QString&)));
	form->addRow(tr("Host name"), hostEdit);

	passEdit = new QLineEdit(this);
	form->addRow(tr("Password"), passEdit);

	ctlEdit = new ResourceControl(this);
	form->addRow(ctlEdit);

	sslEdit = new QCheckBox(tr("The account must use SSL"), this);
	form->addRow(sslEdit);

	sslCtl = new SslControl(this);
	form->addRow(sslCtl);

	dlg = new QDialogButtonBox(BUTTONS, Qt::Horizontal, this);
	connect(dlg, SIGNAL(accepted()), this, SLOT(testData()));
	connect(dlg, SIGNAL(rejected()), this, SLOT(reject()));
	layout->addWidget(dlg, 0, Qt::AlignBottom);

	connect(sslEdit, SIGNAL(clicked(bool)),
		sslCtl, SLOT(setEnabled(bool)));
	sslCtl->setEnabled(sslEdit->isChecked());

	showAccount(QString::null);
	setMinimumWidth(fontMetrics().lineSpacing() * 35);
}

UserDialog::~UserDialog()
{

	delete dlg;
	delete sslCtl;
	delete sslEdit;
	delete ctlEdit;
	delete passEdit;
	delete hostEdit;
	delete userEdit;
	delete labAccount;
	delete form;
	delete layout;
}


void
UserDialog::showAccount(const QString&)
{
	SqlUser	usr;

	usr.setUser(userEdit->text());
	usr.setHost(hostEdit->text());
	labAccount->setText(usr.account(TRUE));
}


void
UserDialog::getData(User &usr)const
{

	usr.setUser(userEdit->text());
	usr.setHost(hostEdit->text());
	usr.setPassword(passEdit->text());
	if (sslCtl->isEnabled())
		sslCtl->getData(usr);
	else
		usr.setSslType(User::SSL_NONE);
	ctlEdit->getData(usr);
}


void
UserDialog::setData(const User &user)
{

	userEdit->setText(user.user());
	hostEdit->setText(user.host());
	passEdit->setText(user.password());
	sslEdit->setChecked(user.sslType() != User::SSL_NONE);
	sslCtl->setEnabled(sslEdit->isChecked());
	if (sslCtl->isEnabled())
		sslCtl->setData(user);
	ctlEdit->setData(user);
	showAccount(QString::null);
}


void
UserDialog::testData()
{
	QString	user(userEdit->text()),
		host(hostEdit->text()),
		pass(passEdit->text()),
		caption(tr("Account warning!"));
	bool	acc = FALSE;

	if (user.isEmpty() && host.isEmpty() && pass.isEmpty()) {
		acc = (QMessageBox::warning(this, caption,
			tr("You have not filled the account data:\n"
			"username, host and password!\n"
			"I hope that it is a mistake, otherwise it is "
			"absolutely insecure!\n"
			"But, if you know what you do, you may continue\n"
			"Continue anyway?"),
			QMessageBox::Yes | QMessageBox::No,
			QMessageBox::No) == QMessageBox::Yes);
	} else if (user.isEmpty()) {
		acc = (QMessageBox::warning(this, caption,
			tr("You have not filled username.\n"
			"It is insecure, continue anyway?"),
			QMessageBox::Yes | QMessageBox::No, QMessageBox::No) ==
			QMessageBox::Yes);
	} else if (host.isEmpty()) {
		acc = (QMessageBox::warning(this, caption,
			tr("You have not filled hostname,\n"
			"The user will be able to connect from all hosts.\n"
			"It is insecure, continue anyway?"),
			QMessageBox::Yes | QMessageBox::No, QMessageBox::No) ==
			QMessageBox::Yes);
	} else if (pass.isEmpty()) {
		acc = (QMessageBox::warning(this, caption,
			tr("You have not filled password,\n"
			"the account could be used by hackers!\n"
			"It is insecure, continue anyway?"),
			QMessageBox::Yes | QMessageBox::No, QMessageBox::No) ==
			QMessageBox::Yes);
	} else if (!sslEdit->isChecked()) {
		QMessageBox::warning(this, caption,
			tr("You don't use security connection "
			"(data encription)\n"
			"It reduces security of your server "
			"and this account"));
		acc = TRUE;
	} else
		acc = TRUE;

	if (acc)
		accept();
}

/* EOF */
