/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: user_dialog.h,v 1.6 2013/09/03 10:28:30 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __USER_DIALOG_H__
#define __USER_DIALOG_H__

#include "gui.h"
#include "user.h"
#include "resource_control.h"
#include "ssl_control.h"


class UserDialog:public QDialog
{
	Q_OBJECT
public:
	UserDialog(QWidget *parent = NULL);
	~UserDialog();

	void	getData(User&)const;
	void	setData(const User&);

private:
	QVBoxLayout		*layout;
	QFormLayout		*form;
	QLabel			*labAccount;
	QLineEdit		*userEdit;
	QLineEdit		*hostEdit;
	QLineEdit		*passEdit;
	ResourceControl		*ctlEdit;
	QCheckBox		*sslEdit;
	SslControl		*sslCtl;
	QDialogButtonBox	*dlg;

private slots:
	void	showAccount(const QString&);
	void	testData();
};

#endif  /* __USER_DIALOG_H__ */

/* EOF */
