/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: user_model.h,v 1.4 2013/09/03 10:28:30 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __USER_MODEL_H__
#define __USER_MODEL_H__

#include "gui.h"
#include "user.h"
#include "sql_error.h"

class SqlConnection;
class SqlQuery;

class UserModel:public QAbstractTableModel
{
	Q_OBJECT
public:
	UserModel(SqlConnection *, QObject *parent = NULL);
	virtual ~UserModel();

	void	timeout();
	void	createUser(const User&, SqlError&);
	void	deleteUser(const QString&, SqlError&);
	void	updateUser(const User&, SqlError&, const User&);
	void	renameUser(const User&, const User&, SqlError&);

	User	*user(const QModelIndex&)const;
	User	*user(int)const;
	User	*user(const QString&)const;
	QModelIndex	indexOfNew();

	virtual QVariant	data(const QModelIndex&, int)const;
	virtual QVariant	headerData(int, Qt::Orientation, int)const;
	virtual int		columnCount(const QModelIndex&)const;
	virtual int		rowCount(const QModelIndex&)const;

private:
	QString		systable;
	UserVector	vect;
	UserMap		map;
	SqlQuery	*query;
	quint64		crc, checksum;
	QString		facc;

	void	copyData(User&, SqlQuery *);
	void	updateData(User *, const User&, unsigned long&);
	void	changed(int&, int, User *, unsigned long&);
	void	markAll();
	void	deleteMarked(unsigned long&);

	QVariant	displayData(const User *, int)const;
	QVariant	backgroundData(const User *)const;
	int		findPosition(const QString&);

private slots:
	void	reloadData();

signals:
	void	modelChanged();
};

#endif  /* __USER_MODEL_H__ */

/* EOF */
