/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: user_privileges.h,v 1.12 2013/09/20 11:35:54 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __USER_PRIVILEGES_H__
#define __USER_PRIVILEGES_H__

#include "gui.h"
#include "sql_user.h"
#include "server_info.h"

class PrivGlobal;
class PrivDatabase;
class PrivTable;
class PrivColumn;
class PrivProc;
class SqlConnection;

class UserPrivileges:public QWidget
{
	Q_OBJECT
public:
	UserPrivileges(ServerInfo *, QWidget *parent = NULL);
	~UserPrivileges();

	void	timeout();
	void	privilegesChanged();

private:
	ServerInfo		*info;
	SqlUser			curr_user;
	QVBoxLayout		*layout, *p_layout;
	QScrollArea		*area;
	QWidget			*priv;
	PrivGlobal		*p_global;
	PrivDatabase		*p_dbase;
	PrivTable		*p_table;
	PrivColumn		*p_column;
	PrivProc		*p_proc;
	QDialogButtonBox	*dlg;
	QPushButton		*commit;

	void	clear();

	bool	isChanged()const;

public slots:
	void	loadPrivileges(const SqlUser&);

private slots:
	void	testCommit();
	void	commitPrivileges();
};

#endif  /* __USER_PRIVILEGES_H__ */

/* EOF */
