/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: users.cpp,v 1.5 2013/09/16 11:42:47 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "users.h"
#include "sql_connection.h"
#include "user_list.h"


Users::Users(ServerInfo *ptr, QWidget *parent)
	:QWidget(parent), info(ptr)
{

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	list = new UserList(info->connection, this);
	connect(list, SIGNAL(selected(bool)), this, SLOT(setCtlEnabled(bool)));
	connect(list, SIGNAL(activated(const SqlUser&)),
		SIGNAL(selected(const SqlUser&)));
	layout->addWidget(list, 1);

	hbox = new QHBoxLayout();
	layout->addLayout(hbox);

	legend = Core::accountLegend(this);
	hbox->addWidget(legend, 1);

	dlg = new QDialogButtonBox(Qt::Vertical, this);
	hbox->addWidget(dlg, 0, Qt::AlignRight | Qt::AlignVCenter);

	add = new QPushButton(this);
	connect(add, SIGNAL(clicked()), list, SLOT(addUser()));
	add->setIcon(QIcon(":/icons/add.png"));
	add->setFocusPolicy(Qt::NoFocus);
	add->setToolTip(tr("Create a new SQL account"));
	dlg->addButton(add, QDialogButtonBox::ActionRole);

	edt = new QPushButton(this);
	connect(edt, SIGNAL(clicked()), list, SLOT(editUser()));
	edt->setIcon(QIcon(":/icons/edit.png"));
	edt->setFocusPolicy(Qt::NoFocus);
	edt->setToolTip(tr("Edit current SQL account"));
	dlg->addButton(edt, QDialogButtonBox::ActionRole);

	del = new QPushButton(this);
	connect(del, SIGNAL(clicked()), list, SLOT(delUser()));
	del->setIcon(QIcon(":/icons/delete.png"));
	del->setFocusPolicy(Qt::NoFocus);
	del->setToolTip(tr("Drop current SQL account"));
	dlg->addButton(del, QDialogButtonBox::ActionRole);

	setCtlEnabled(FALSE);
}

Users::~Users()
{

	delete del;
	delete edt;
	delete add;
	delete dlg;
	delete legend;
	delete hbox;
	delete list;
	delete layout;
}


void
Users::timeout()
{

	list->timeout();
}


void
Users::privilegesChanged()
{

	dlg->setEnabled(info->priv.isSet(PRIV_CREATE_USER));
}


void
Users::setCtlEnabled(bool ena)
{

	edt->setEnabled(ena);
	del->setEnabled(ena);
}

/* EOF */
