/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: users.h,v 1.5 2013/09/16 11:42:47 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __USERS_H__
#define __USERS_H__

#include "gui.h"
#include "server_info.h"

class SqlConnection;
class UserList;
class SqlUser;

class Users:public QWidget
{
	Q_OBJECT
public:
	Users(ServerInfo *, QWidget *parent = NULL);
	~Users();

	void	timeout();
	void	privilegesChanged();

private:
	ServerInfo		*info;
	QVBoxLayout		*layout;
	QHBoxLayout		*hbox;
	UserList		*list;
	QWidget			*legend;
	QDialogButtonBox	*dlg;
	QPushButton		*add;
	QPushButton		*edt;
	QPushButton		*del;

private slots:
	void	setCtlEnabled(bool);

signals:
	void	selected(const SqlUser&);
};

#endif  /* __USERS_H__ */

/* EOF */
