/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: plugins.h,v 1.3 2013/09/13 12:53:22 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __PLUGINS_H__
#define __PLUGINS_H__

#include "gui.h"
#include "sql_service.h"


class MySQLPluginModel;
class Plugin;

class Plugins:public QWidget, public SqlService
{
	Q_OBJECT
public:
	Plugins(ServerInfo *, QWidget *parent = NULL);
	virtual ~Plugins();

	virtual void	timeout();

	virtual QString	tabName();

private:
	QVBoxLayout		*layout;
	QTableView		*view;
	QDialogButtonBox	*dlg;
	MySQLPluginModel	*model;
	QPushButton		*info;
	QPushButton		*load;
	QPushButton		*unload;

protected:
	virtual void	destroyIt();

public slots:
	void	deleteNow();

private slots:
	void	selectItem();
	void	loadPlugin();
	void	unloadPlugin();
	void	unloadPlugin(const QModelIndex&);
	void	pluginInfo();
	void	pluginInfo(const QModelIndex&);
	void	testPlugin(const QModelIndex&, const QModelIndex&);
};

//-----------------------------------------------------------------------------

class PluginDialog:public QDialog
{
	Q_OBJECT
public:
	PluginDialog(QWidget *parent = NULL);
	~PluginDialog();

	QString	pluginName()const;
	QString	pluginLibrary()const;

private:
	QVBoxLayout		*layout;
	QFormLayout		*form;
	QLineEdit		*nameEdit;
	QLineEdit		*pathEdit;
	QDialogButtonBox	*dlg;

private slots:
	void	canAccept(const QString&);
};

//-----------------------------------------------------------------------------

class PluginInfo:public QWidget
{
	Q_OBJECT
public:
	PluginInfo(QWidget *parent = NULL);
	~PluginInfo();

	void	setPluginInfo(const Plugin *);

private:
	QVBoxLayout	*layout, *lBox;
	QFormLayout	*form;
	QLabel		*lPluginName;
	QLabel		*lPluginVersion;
	QLabel		*lPluginStatus;
	QLabel		*lPluginType;
	QLabel		*lPluginTypeVersion;
	QLabel		*lPluginLibrary;
	QLabel		*lPluginLibraryVersion;
	QLabel		*lPluginAuthor;
	QLabel		*lPluginAuthVersion;
	QLabel		*lPluginLicense;
	QLabel		*lLoadOption;
	QLabel		*lPluginMaturity;
	QGroupBox	*bDesc;
	QLabel		*lDescription;
};

//-----------------------------------------------------------------------------

class PluginInfoDialog:public QDialog
{
	Q_OBJECT
public:
	PluginInfoDialog(QWidget *parent = NULL);
	~PluginInfoDialog();

	void	setPluginInfo(const Plugin *);

private:
	QVBoxLayout		*layout;
	PluginInfo		*info;
	QDialogButtonBox	*dlg;
};

#endif  /* __PLUGINS_H__ */

/* EOF */
