/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: plg_processlist.cpp,v 1.5 2013/09/13 12:53:23 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "plg_processlist.h"
#include "processlist.h"


PluginProcessList::PluginProcessList(QObject *parent)
	:QObject(parent), ServicePlugin("processlist",
	tr("This plugin shows all processes on a server"))
{

	Q_INIT_RESOURCE(processlist);
	initTranslator(LOCALE_FILE);
}

PluginProcessList::~PluginProcessList()
{

	/* close all our widgets */
	emit closeWidget();

	Q_CLEANUP_RESOURCE(processlist);
}


QWidget *
PluginProcessList::create(ServerInfo *info, QWidget *parent)
{
	ProcessList	*ret;

	ret = new ProcessList(info, parent);
	connect(this, SIGNAL(closeWidget()), ret, SLOT(deleteNow()));
	/* FIXME: добавить некоторые слоты и сигналы */

	return (ret);
}

Q_EXPORT_PLUGIN2(processlist, PluginProcessList)

/* EOF */
