/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: process.cpp,v 1.3 2013/08/20 10:12:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "process.h"


Process::Process()
	:BasicData()
{

	setId(0);
	setUser(QString::null);
	setHost(QString::null);
	setDb(QString::null);
	setCommand(QString::null);
	setTime(0);
	setState(QString::null);
	setInfo(QString::null);
	setTimeMs(0.0);
	setStage(0);
	setMaxStage(0);
	setProgress(0.0);
	setMemoryUsed(0);
	setExaminedRows(0);
}

Process::Process(const Process &proc)
	:BasicData()
{

	setProcess(proc);
}

Process::~Process()
{
}


void
Process::setProcess(const Process &proc)
{

	setId(proc.id());
	setUser(proc.user());
	setHost(proc.host());
	setDb(proc.db());
	setCommand(proc.command());
	setTime(proc.time());
	setState(proc.state());
	setInfo(proc.info());
	setTimeMs(proc.timeMs());
	setStage(proc.stage());
	setMaxStage(proc.maxStage());
	setProgress(proc.progress());
	setMemoryUsed(proc.memoryUsed());
	setExaminedRows(proc.examinedRows());
	setInternalFlags(proc.flags());
}


void
Process::setId(unsigned long id)
{

	p_id = id;
}


void
Process::setUser(const QString &u)
{

	p_user = u;
}


void
Process::setHost(const QString &h)
{

	p_host = h;
}


void
Process::setDb(const QString &db)
{

	p_db = db;
}


void
Process::setCommand(const QString &c)
{

	p_command = c;
}


void
Process::setTime(int t)
{

	p_time = t;
}


void
Process::setState(const QString &s)
{

	p_state = s;
}


void
Process::setInfo(const QString &i)
{

	p_info = i;
}


void
Process::setTimeMs(double tms)
{

	p_time_ms = tms;
}


void
Process::setStage(int s)
{

	p_stage = s;
}


void
Process::setMaxStage(int ms)
{

	p_max_stage = ms;
}


void
Process::setProgress(double p)
{

	p_progress = p;
}


void
Process::setMemoryUsed(int mu)
{

	p_memory_used = mu;
}


void
Process::setExaminedRows(int er)
{

	p_examined_rows = er;
}


unsigned long
Process::id()const
{

	return (p_id);
}


QString
Process::user()const
{

	return (p_user);
}


QString
Process::host()const
{

	return (p_host);
}


QString
Process::db()const
{

	return (p_db);
}


QString
Process::command()const
{

	return (p_command);
}


int
Process::time()const
{

	return (p_time);
}


QString
Process::state()const
{

	return (p_state);
}


QString
Process::info()const
{

	return (p_info);
}


double
Process::timeMs()const
{

	return (p_time_ms);
}


int
Process::stage()const
{

	return (p_stage);
}


int
Process::maxStage()const
{

	return (p_max_stage);
}


double
Process::progress()const
{

	return (p_progress);
}


int
Process::memoryUsed()const
{

	return (p_memory_used);
}


int
Process::examinedRows()const
{

	return (p_examined_rows);
}

/* EOF */
