/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: process.h,v 1.2 2013/07/31 13:41:36 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __PROCESS_H__
#define __PROCESS_H__

#include "gui.h"
#include "basic_data.h"

class Process;
typedef	QVector<Process *>	ProcessVector;
typedef	QMap<qint64, Process *>	ProcessMap;

class Process:public BasicData
{
public:
	Process();
	Process(const Process&);
	~Process();

	void	setProcess(const Process&);
	void	setId(unsigned long);
	void	setUser(const QString&);
	void	setHost(const QString&);
	void	setDb(const QString&);
	void	setCommand(const QString&);
	void	setTime(int);
	void	setState(const QString&);
	void	setInfo(const QString&);
	void	setTimeMs(double);
	void	setStage(int);
	void	setMaxStage(int);
	void	setProgress(double);
	void	setMemoryUsed(int);
	void	setExaminedRows(int);

	unsigned long	id()const;
	QString		user()const;
	QString		host()const;
	QString		db()const;
	QString		command()const;
	int		time()const;
	QString		state()const;
	QString		info()const;
	double		timeMs()const;
	int		stage()const;
	int		maxStage()const;
	double		progress()const;
	int		memoryUsed()const;
	int		examinedRows()const;

private:
	unsigned long	p_id;			/* processlist.id */
	QString		p_user;			/* processlist.user */
	QString		p_host;			/* processlist.host */
	QString		p_db;			/* processlist.db */
	QString		p_command;		/* processlist.command */
	int		p_time;			/* processlist.time */
	QString		p_state;		/* processlist.state */
	QString		p_info;			/* processlist.info */
	double		p_time_ms;		/* processlist.time_ms */
	int		p_stage;		/* processlist.stage */
	int		p_max_stage;		/* processlist.max_stage */
	double		p_progress;		/* processlist.progress */
	int		p_memory_used;		/* processlist.memory_used */
	int		p_examined_rows;	/* processlist.examined_rows */
};

#endif  /* __PROCESS_H__ */

/* EOF */
