/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: process_field.cpp,v 1.4 2013/08/20 10:12:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "process_field.h"


ProcessField::ProcessField()
	:BasicData()
{

	setName(QString::null);
	setDescription(QString::null);
	setPosition(-1);
}

ProcessField::ProcessField(const QString &name, const QString &desc)
	:BasicData()
{

	setName(name);
	setDescription(desc);
	setPosition(-1);
}

ProcessField::ProcessField(const ProcessField &fld)
	:BasicData()
{

	setField(fld);
}

ProcessField::~ProcessField()
{
}


void
ProcessField::setField(const ProcessField &fld)
{

	setName(fld.name());
	setDescription(fld.description());
	setPosition(fld.position());
	setInternalFlags(fld.flags());
}


void
ProcessField::setName(const QString &name)
{

	p_name = name;
}


void
ProcessField::setDescription(const QString &desc)
{

	p_desc = desc;
}


void
ProcessField::setPosition(int pos)
{

	p_pos = pos;
}


QString
ProcessField::name()const
{

	return (p_name);
}


QString
ProcessField::description()const
{

	return (p_desc);
}


int
ProcessField::position()const
{

	return (p_pos);
}


ProcessField&
ProcessField::operator=(const ProcessField &fld)
{

	setField(fld);

	return (*this);
}

/* EOF */
