/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: process_field.h,v 1.2 2013/07/31 13:41:36 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __PROCESS_FIELD_H__
#define __PROCESS_FIELD_H__

#include "gui.h"
#include "basic_data.h"


class ProcessField;
typedef	QVector<ProcessField *>		FieldVector;
typedef	QMap<QString, ProcessField *>	FieldMap;


class ProcessField:public BasicData
{
public:
	ProcessField();
	ProcessField(const QString&, const QString&);
	ProcessField(const ProcessField&);
	~ProcessField();

	void	setField(const ProcessField&);
	void	setName(const QString&);
	void	setDescription(const QString&);
	void	setPosition(int);

	QString	name()const;
	QString	description()const;
	int	position()const;

	ProcessField&	operator=(const ProcessField&);

private:
	QString	p_name;
	QString	p_desc;
	int	p_pos;
};

#endif  /* __PROCESS_FIELD_H__ */

/* EOF */
