/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: process_model.h,v 1.5 2013/08/02 12:49:35 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __PROCESS_MODEL_H__
#define __PROCESS_MODEL_H__

#include "gui.h"
#include "process.h"
#include "process_field.h"


#define	BRUSH_MY_ID	QBrush(Qt::gray, Qt::Dense4Pattern)

class SqlConnection;
class SqlQuery;


class ProcessModel:public QAbstractTableModel
{
	Q_OBJECT
public:
	ProcessModel(SqlConnection *, QObject *parent = NULL);
	virtual ~ProcessModel();

	void	timeout();
	void	kill(const QModelIndex&, QWidget *parent);

	bool	isEmpty()const;
	Process	*process(const QModelIndex&)const;
	Process	*process(int)const;

	virtual QVariant	data(const QModelIndex&, int)const;
	virtual QVariant	headerData(int, Qt::Orientation, int)const;
	virtual int		columnCount(const QModelIndex&)const;
	virtual int		rowCount(const QModelIndex&)const;

private:
	FieldVector	f_vect;
	FieldMap	f_map;
	ProcessVector	vect;
	ProcessMap	map;
	SqlQuery	*query;
	bool		smt;	/* show my thread */
#if	defined(FEATURES)
	SqlQuery	*qtf;
#endif	/* FEATURES */

	void	addField(const QString&, const QString&, bool mark = TRUE);
	void	testFeatures(SqlConnection *);
	void	markAll();
	void	deleteMarked(unsigned long&);
	void	copyData(Process&, SqlQuery *);
	void	updateData(Process *, const Process&, unsigned long&);
	void	changed(int&, int, Process *, unsigned long&);
	void	destroyVector();

	int		findPosition(unsigned long);
	QVariant	displayData(const Process *, int)const;
	QVariant	backgroundData(const Process *)const;
	unsigned long	myThreadId()const;
	int		fieldPosition(const char *);

public slots:
	void	switchMyThread(int);

private slots:
	void	reloadData();

signals:
	void	modelChanged();
};

#endif  /* __PROCESS_MODEL_H__ */

/* EOF */
