/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: processlist.cpp,v 1.6 2013/10/09 14:18:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "processlist.h"
#include "process_model.h"


ProcessList::ProcessList(ServerInfo *info, QWidget *parent)
	:QWidget(parent), SqlService(info, "processlist")
{

	model = new ProcessModel(connection(), this);
	connect(model, SIGNAL(modelChanged()), this, SLOT(selectItem()));

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	view = new QTableView(this);
	connect(view, SIGNAL(doubleClicked(const QModelIndex&)),
		this, SLOT(killThread(const QModelIndex&)));
	view->setModel(model);
	TABLE_VIEW_INIT(view);
	layout->addWidget(view, 1);

	ctl = new QHBoxLayout();
	layout->addLayout(ctl);

	mythr = new QCheckBox(tr("Hide my thread"), this);
	mythr->setChecked(TRUE);
	connect(mythr, SIGNAL(stateChanged(int)),
		model, SLOT(switchMyThread(int)));
	ctl->addWidget(mythr, 0, Qt::AlignLeft);

	leg = Core::addLegendItem(tr("My own thread"), BRUSH_MY_ID, this);
	ctl->addWidget(leg, 1, Qt::AlignCenter);

	kill = new QPushButton(QIcon(":/icons/gun.png"), tr("Kill"), this);
	connect(kill, SIGNAL(clicked()), this, SLOT(killThread()));
	ctl->addWidget(kill, 0, Qt::AlignRight);

	selectItem();
}

ProcessList::~ProcessList()
{

	delete kill;
	delete leg;
	delete mythr;
	delete ctl;
	delete view;
	delete layout;
	delete model;
}


void
ProcessList::timeout()
{

	if (isEnabled())
		model->timeout();
}


void
ProcessList::privilegesChanged()
{

	setEnabled(info()->priv.isSet(PRIV_PROCESS));
}


QString
ProcessList::tabName()
{

	return (tr("Process list"));
}


void
ProcessList::destroyIt()
{

	delete this;
}


void
ProcessList::deleteNow()
{

	destroyIt();
}


void
ProcessList::killThread()
{

	killThread(view->currentIndex());
}


void
ProcessList::killThread(const QModelIndex &ndx)
{

	model->kill(ndx, this);
}


void
ProcessList::selectItem()
{
	QItemSelectionModel	*sel = view->selectionModel();

	if ((sel != NULL) && !sel->hasSelection())
		view->setCurrentIndex(model->index(0, 0));

	kill->setEnabled(!model->isEmpty());
}

/* EOF */
