/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: abstract_editor.cpp,v 1.3 2013/10/02 12:32:16 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "abstract_editor.h"
#include "sql_connection.h"
#include "sql_error.h"


AbstractEditor::AbstractEditor(QWidget *parent)
	:QDialog(parent), saved(FALSE)
{

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	form = new QFormLayout();
	MARGINS_ZERO(form);

	defval = new QLabel(Core::text(Core::Undefined), this);
	form->addRow(tr("Default value"), defval);

	dlg = new QDialogButtonBox(
		QDialogButtonBox::Save | QDialogButtonBox::Cancel,
		Qt::Horizontal, this);
	connect(dlg, SIGNAL(accepted()), this, SLOT(accept()));
	connect(dlg, SIGNAL(rejected()), this, SLOT(reject()));

	defbut = new QPushButton(tr("Default", "set default value"), dlg);
	defbut->setEnabled(FALSE);
	connect(defbut, SIGNAL(clicked()), this, SLOT(setDefault()));
	dlg->addButton(defbut, QDialogButtonBox::ActionRole);
	setSaveEnabled(FALSE);
	setMinimumWidth(fontMetrics().lineSpacing() * 30);
}

AbstractEditor::~AbstractEditor()
{

	delete defbut;
	delete dlg;
	delete defval;
	delete form;
	delete layout;
}


void
AbstractEditor::addDialog()
{

	layout->addWidget(dlg, 0, Qt::AlignBottom);
}


void
AbstractEditor::addDefaultValue()
{

	layout->addLayout(form);
}


void
AbstractEditor::setDefaultValue(const QString &val)
{
	bool	ena = !val.isEmpty();

	defval->setText(val);
	defbut->setEnabled(ena);
}


void
AbstractEditor::setDefault()
{

	cout<<"AbstractEditor::setDefault()"<<endl;
}


void
AbstractEditor::setSaveEnabled(bool ena)
{
	QPushButton	*btn = dlg->button(QDialogButtonBox::Save);

	FATAL(btn == NULL);
	btn->setEnabled(ena);
}


void
AbstractEditor::doCommit(SqlConnection *conn, const QString &name,
	const QString &value)
{
	SqlError	err;
	QString		query;

	query = "set %1 " + QString("%1 = %2").arg(name).arg(value);

//	err = conn->exec(query.arg("session"));
	err = conn->exec(query.arg("global"));
	if (err != 0)
		err.show(this);
}


QString
AbstractEditor::defaultValue()const
{

	return (defval->text());
}

/* EOF */
