/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: abstract_editor.h,v 1.2 2013/09/30 12:10:24 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __ABSTRACT_EDITOR_H__
#define __ABSTRACT_EDITOR_H__

#include "gui.h"

#define	MY_DOUBLE	long double
#define	SLIDER_MIN	0
#define	SLIDER_MAX	1000000000

#define	SCALE(min, val, max, smin, smax)				\
	static_cast<MY_DOUBLE>(smax - smin) *				\
	(static_cast<MY_DOUBLE>(val) - static_cast<MY_DOUBLE>(min)) /	\
	(static_cast<MY_DOUBLE>(max) - static_cast<MY_DOUBLE>(min)) +	\
	static_cast<MY_DOUBLE>(smin)


class TunableVariable;
class SqlConnection;

class AbstractEditor:public QDialog
{
	Q_OBJECT
public:
	AbstractEditor(QWidget *parent = NULL);
	virtual ~AbstractEditor();

	virtual void	setTemplate(const TunableVariable *) = 0;
	virtual void	setValue(const QString&) = 0;
	virtual void	commit(SqlConnection *, const QString&) = 0;

private:
	QFormLayout		*form;
	QLabel			*defval;
	QDialogButtonBox	*dlg;
	QPushButton		*defbut;

protected:
	QVBoxLayout	*layout;
	bool		saved;

	void	addDialog();
	void	addDefaultValue();
	void	setDefaultValue(const QString&);
	void	setSaveEnabled(bool);
	void	doCommit(SqlConnection *, const QString&, const QString&);

	QString	defaultValue()const;

protected slots:
	virtual void	setDefault();
};

#endif  /* __ABSTRACT_EDITOR_H__ */

/* EOF */
