/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: abstract_variable.cpp,v 1.10 2013/10/07 17:00:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "abstract_variable.h"
#include "status_variable.h"
#include "tunable_variable.h"
#include "tunable_integer.h"
#include "tunable_enumeration.h"
#include "tunable_unsigned.h"
#include "tunable_boolean.h"
#include "tunable_combo.h"
#include "tunable_string.h"
#include "tunable_set.h"
#include "tunable_real.h"
#include "tunable_optimizer_switch.h"

typedef	QMap<QString, AbstractVariable *>	VariableMap;

static void	destroyMap(VariableMap *);
static void	initMap(VariableMap *);


AbstractVariable::AbstractVariable()
{

	setName(QString::null);
	setType(ReadOnly);
	setCommandLine(QStringList());
	setConfigLine(QString::null);
	setDescription(QString::null);
}

AbstractVariable::~AbstractVariable()
{

}


void
AbstractVariable::setName(const QString &name)
{

	p_name = name;
}


void
AbstractVariable::setType(Type type)
{

	p_type = type;
}


void
AbstractVariable::setCommandLine(const QStringList &cmd)
{

	p_cmd = cmd;
}


void
AbstractVariable::setConfigLine(const QString &cfg)
{

	p_config = cfg;
}


void
AbstractVariable::setDescription(const QString &desc)
{

	p_desc = desc;
}


QString
AbstractVariable::name()const
{

	return (p_name);
}


AbstractVariable::Type
AbstractVariable::type()const
{

	return (p_type);
}


QStringList
AbstractVariable::commandLine()const
{

	return (p_cmd);
}


QString
AbstractVariable::configLine()const
{

	return (p_config);
}


QString
AbstractVariable::description()const
{

	return (p_desc);
}

//-----------------------------------------------------------------------------

AbstractVariable *
AbstractVariable::lookup(const char *name)
{
	static VariableMap	*map = NULL;
	AbstractVariable	*ret = NULL;

	if ((map == NULL) && (name != NULL)) {
		map = new VariableMap();
		initMap(map);
		goto HAXEP;
	} else if ((name == NULL) && (map != NULL)) {
		destroyMap(map);
		SAFE_DELETE(map);
	} else if (map != NULL) {
		HAXEP:
		ret = map->value(name, NULL);
	}

	return (ret);
}

//-----------------------------------------------------------------------------

void
destroyMap(VariableMap *map)
{
	VariableMap::iterator	it;
	AbstractVariable	*ptr;

	for (it = map->begin(); it != map->end(); ) {
		ptr = *it;
		it = map->erase(it);
		delete ptr;
	}
}

#include "status.hpp"
#include "variable.hpp"

void
initMap(VariableMap *map)
{

	initStatus(map);
	initVariable(map);
}

/* EOF */
