/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: abstract_variable.h,v 1.2 2013/09/23 13:54:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __ABSTRACT_VARIABLE_H__
#define __ABSTRACT_VARIABLE_H__

#include "gui.h"

#define	BRUSH_UNKNOWN		QBrush(QColor(0xFF, 0xA1, 0xA1))
#define	BRUSH_READWRITE		QBrush(Qt::green)
#define	BRUSH_READONLY		QBrush(QColor(0xFF, 0xFF, 0x86))


class AbstractEditor;

class AbstractVariable
{
public:
	enum Type {
		ReadOnly,
		ReadWrite
	};

	AbstractVariable();
	virtual ~AbstractVariable();

	QString		name()const;
	Type		type()const;
	QStringList	commandLine()const;
	QString		configLine()const;
	QString		description()const;

	static AbstractVariable	*lookup(const char *);

private:
	Type		p_type;
	QString		p_name;
	QStringList	p_cmd;
	QString		p_config;
	QString		p_desc;

protected:
	void	setName(const QString&);
	void	setType(Type);
	void	setCommandLine(const QStringList&);
	void	setConfigLine(const QString&);
	void	setDescription(const QString&);
};

#endif  /* __ABSTRACT_VARIABLE_H__ */

/* EOF */
