/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: boolean_editor.cpp,v 1.1 2013/10/01 12:02:32 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "boolean_editor.h"
#include "sql_connection.h"
#include "sql_error.h"
#include "tunable_boolean.h"


BooleanEditor::BooleanEditor(QWidget *parent)
	:AbstractEditor(parent), curr_value(FALSE), saved_value(FALSE)
{

	desc = new QLabel(this);
	desc->setAlignment(Qt::AlignLeft | Qt::AlignTop);
	desc->setWordWrap(TRUE);
	layout->addWidget(desc, 1);

	addDefaultValue();

	cbox = new QCheckBox(this);
	connect(cbox, SIGNAL(clicked()), this, SLOT(changed()));
	layout->addWidget(cbox);

	addDialog();
}

BooleanEditor::~BooleanEditor()
{

	delete cbox;
	delete desc;
}


void
BooleanEditor::setTemplate(const TunableVariable *var)
{
	const TunableBoolean	*tbool;

	FATAL(var->type() != TunableVariable::T_BOOL);
	tbool = static_cast<const TunableBoolean *>(var);
	desc->setText(var->description());
	cbox->setText(var->name());

	setDefaultValue(Core::bool2string(tbool->value()));
	setDefault();
	saved = FALSE;
}


void
BooleanEditor::setValue(const QString &val)
{

	curr_value = Core::string2bool(val);
	cbox->setChecked(curr_value);
	if (!saved) {
		saved = TRUE;
		saved_value = curr_value;
	}
	setSaveEnabled(curr_value != saved_value);
}


void
BooleanEditor::changed()
{

	curr_value = cbox->isChecked();
	setSaveEnabled(curr_value != saved_value);
}


void
BooleanEditor::setDefault()
{

	setValue(defaultValue());
}


void
BooleanEditor::commit(SqlConnection *conn, const QString &name)
{

	doCommit(conn, name, Core::bool2string(curr_value));
}

/* EOF */
