/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: combo_editor.cpp,v 1.1 2013/10/02 12:32:16 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "combo_editor.h"
#include "sql_connection.h"
#include "sql_error.h"
#include "tunable_combo.h"


ComboEditor::ComboEditor(QWidget *parent)
	:AbstractEditor(parent), curr_value(QString::null),
	saved_value(QString::null)
{

	desc = new QLabel(this);
	desc->setAlignment(Qt::AlignLeft | Qt::AlignTop);
	desc->setWordWrap(TRUE);
	layout->addWidget(desc, 1);

	addDefaultValue();

	cbox = new QComboBox(this);
	connect(cbox, SIGNAL(currentIndexChanged(const QString&)),
		this, SLOT(changed(const QString&)));
	layout->addWidget(cbox);

	addDialog();
}

ComboEditor::~ComboEditor()
{

	delete cbox;
	delete desc;
}


void
ComboEditor::setTemplate(const TunableVariable *var)
{
	const TunableCombo	*tcombo;

	FATAL(var->type() != TunableVariable::T_COMBO);
	tcombo = static_cast<const TunableCombo *>(var);
	desc->setText(var->description());
	cbox->clear();
	cbox->addItems(tcombo->list());

	setDefaultValue(tcombo->value());
	setDefault();
	saved = FALSE;
}


void
ComboEditor::setValue(const QString &val)
{
	int	pos;

	if (!val.isEmpty()) {
		pos = cbox->findText(val, Qt::MatchExactly);
		if (pos != -1) {
			curr_value = val;
			cbox->setCurrentIndex(pos);
			if (!saved) {
				saved = TRUE;
				saved_value = curr_value;
			}
			setSaveEnabled(curr_value != saved_value);
		}
	}
}


void
ComboEditor::changed(const QString &txt)
{

	curr_value = txt;
	setSaveEnabled(curr_value != saved_value);
}


void
ComboEditor::setDefault()
{

	setValue(defaultValue());
}


void
ComboEditor::commit(SqlConnection *conn, const QString &name)
{

	doCommit(conn, name, curr_value);
}

/* EOF */
