/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: enumeration_editor.cpp,v 1.3 2013/10/07 17:00:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "enumeration_editor.h"
#include "sql_connection.h"
#include "sql_error.h"
#include "tunable_enumeration.h"


EnumerationEditor::EnumerationEditor(QWidget *parent)
	:AbstractEditor(parent), curr_value(QString::null),
	saved_value(QString::null)
{

	desc = new QLabel(this);
	desc->setAlignment(Qt::AlignLeft | Qt::AlignTop);
	desc->setWordWrap(TRUE);
	layout->addWidget(desc, 1);

	addDefaultValue();

	box = new QGroupBox(this);
	layout->addWidget(box);

	vbox = new QVBoxLayout(box);
	MARGINS_ZERO(vbox);

	addDialog();
}

EnumerationEditor::~EnumerationEditor()
{
	EnumMap::iterator	it;
	QRadioButton		*btn;

	for (it = map.begin(); it != map.end(); ) {
		btn = *it;
		delete btn;
		it = map.erase(it);
	}

	delete vbox;
	delete box;
	delete desc;
}


void
EnumerationEditor::setTemplate(const TunableVariable *var)
{
	const TunableEnumeration	*tenum;
	QRadioButton			*btn;
	EnumVector			vect;
	EnumVector::const_iterator	it;
	EnumItem			item;

	FATAL(var->type() != TunableVariable::T_ENUM);
	tenum = static_cast<const TunableEnumeration *>(var);
	desc->setText(var->description());
	vect = tenum->vector();

	for (it = vect.constBegin(); it != vect.constEnd(); ++it) {
		item = *it;
		btn = new QRadioButton(item.second, box);
		btn->setMinimumHeight(btn->fontMetrics().lineSpacing());
		connect(btn, SIGNAL(clicked()), this, SLOT(changed()));
		vbox->addWidget(btn);
		map.insert(item.first, btn);
	}

	setDefaultValue(tenum->value());
	setDefault();
	saved_value = QString::null;
}


void
EnumerationEditor::setValue(const QString &val)
{
	QRadioButton	*btn;

	btn = map.value(val, NULL);
	if (btn == NULL)
		btn = scan(val);
	if (btn != NULL) {
		btn->setChecked(TRUE);
		curr_value = val;
		if (saved_value.isEmpty())
			saved_value = curr_value;
		setSaveEnabled(curr_value != saved_value);
	}
}


QRadioButton *
EnumerationEditor::scan(const QString &val)const
{
	EnumMap::const_iterator	it;
	QRadioButton		*tmp, *ret = NULL;

	for (it = map.constBegin(); it != map.constEnd(); ++it) {
		tmp = it.value();
		if (tmp->text().compare(val, Qt::CaseInsensitive) == 0) {
			ret = tmp;
			break;
		}
	}

	return (ret);
}


void
EnumerationEditor::changed()
{
	EnumMap::const_iterator	it;
	QRadioButton		*btn;
	QString			key;
	bool			ena = FALSE;

	for (it = map.constBegin(); it != map.constEnd(); ++it) {
		btn = *it;
		key = it.key();
		if (btn->isChecked() && (curr_value != key)) {
			curr_value = key;
			ena = TRUE;
			break;
		}
	}
	ena &= (curr_value != saved_value);
	setSaveEnabled(ena);
}


void
EnumerationEditor::setDefault()
{

	setValue(defaultValue());
}


void
EnumerationEditor::commit(SqlConnection *conn, const QString &name)
{

	doCommit(conn, name, QString("'%1'").arg(curr_value));
}

/* EOF */
