/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: informer.cpp,v 1.4 2013/10/09 14:18:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "informer.h"
#include "tunable.h"
#include "abstract_variable.h"


Informer::Informer(Tunable *tune, QWidget *parent)
	:QWidget(parent)
{
	AbstractVariable	*av = tune->parent();
	QFont			fnt;

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	form = new QFormLayout();
	MARGINS_ZERO(form);
	layout->addLayout(form);

	lname = new QLabel(tune->prettyName(), this);
	fnt = lname->font();
	fnt.setBold(TRUE);
	lname->setFont(fnt);
	form->addRow(tr("Name"), lname);

	lval = new QLabel(tune->value(), this);
	fnt = lval->font();
	fnt.setBold(TRUE);
	lval->setFont(fnt);
	form->addRow(tr("Current value"), lval);

	lcmd = new QLabel(Core::text(Core::None), this);
	lcmd->setWordWrap(FALSE);
	fnt = lcmd->font();
	fnt.setBold(TRUE);
	lcmd->setFont(fnt);
	form->addRow(tr("Command line option"), lcmd);

	lini = new QLabel(Core::text(Core::None), this);
	lini->setWordWrap(FALSE);
	fnt = lini->font();
	fnt.setBold(TRUE);
	lini->setFont(fnt);
	form->addRow(tr("Config file option"), lini);

	box = new QGroupBox(tr("Description of the variable"), this);
	box->setAlignment(Qt::AlignHCenter);
	layout->addWidget(box, 1);

	lbox = new QVBoxLayout(box);
	MARGINS_ZERO(lbox);

	info = new QTextBrowser(box);
	lbox->addWidget(info, 1);
	info->setReadOnly(TRUE);
	info->setOpenLinks(FALSE);
	if (av != NULL)
		showInfo(av);
}

Informer::~Informer()
{

	delete info;
	delete lbox;
	delete box;
	delete lini;
	delete lcmd;
	delete lval;
	delete lname;
	delete form;
	delete layout;
}


void
Informer::showInfo(const AbstractVariable *av)
{
	QString		cmd(av->configLine());
	QStringList	list(av->commandLine());

	info->setHtml(av->description());

	if (!cmd.isEmpty())
		lini->setText(cmd);

	if (!list.isEmpty())
		lcmd->setText(list.join(", "));
}

//-----------------------------------------------------------------------------

MessageInformer::MessageInformer(Tunable *tune, QWidget *parent)
	:QDialog(parent)
{
	AbstractVariable	*av = tune->parent();

	setWindowTitle(tune->prettyName());

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	info = new Informer(tune, this);
	layout->addWidget(info, 1);

	dlg = new QDialogButtonBox(QDialogButtonBox::Ok, Qt::Horizontal, this);
	connect(dlg, SIGNAL(accepted()), this, SLOT(accept()));
	connect(dlg, SIGNAL(rejected()), this, SLOT(reject()));
	layout->addWidget(dlg, 0, Qt::AlignBottom);

	if (av->type() == AbstractVariable::ReadWrite) {
		bEdit = new QPushButton(QIcon(":/icons/edit.png"),
			tr("Modify"), this);
		connect(bEdit, SIGNAL(clicked()), this, SLOT(editClicked()));
		dlg->addButton(bEdit, QDialogButtonBox::ActionRole);
	} else
		bEdit = NULL;

	resize(640, 480);
	setMinimumSize(size());
}

MessageInformer::~MessageInformer()
{

	SAFE_DELETE(bEdit);
	delete dlg;
	delete info;
	delete layout;
}


void
MessageInformer::editClicked()
{

	accept();
	emit edit();
}

/* EOF */
