/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: optimizer_switch_editor.cpp,v 1.1 2013/10/07 17:00:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "optimizer_switch_editor.h"
#include "sql_connection.h"
#include "sql_error.h"
#include "tunable_optimizer_switch.h"

static const QChar	sep(','), sep2('=');


OptimizerSwitchEditor::OptimizerSwitchEditor(QWidget *parent)
	:AbstractEditor(parent), curr_value(QStringList()),
	saved_value(QStringList())
{

	desc = new QLabel(this);
	desc->setAlignment(Qt::AlignLeft | Qt::AlignTop);
	desc->setWordWrap(TRUE);
	layout->addWidget(desc, 1);

	addDefaultValue();

	box = new QGroupBox(this);
	layout->addWidget(box);

	vbox = new QVBoxLayout(box);
	MARGINS_ZERO(vbox);

	addDialog();
}

OptimizerSwitchEditor::~OptimizerSwitchEditor()
{
	SetMap::iterator	it;
	QCheckBox		*btn;

	for (it = map.begin(); it != map.end(); ) {
		btn = *it;
		delete btn;
		it = map.erase(it);
	}

	delete vbox;
	delete box;
	delete desc;
}


void
OptimizerSwitchEditor::setTemplate(const TunableVariable *var)
{
	const TunableOptimizerSwitch	*tosw;
	QCheckBox			*btn;
	QStringList			list, val;
	QStringList::const_iterator	it;

	FATAL(var->type() != TunableVariable::T_OPTIMIZER_SWITCH);
	tosw = static_cast<const TunableOptimizerSwitch *>(var);
	desc->setText(var->description());
	list = tosw->value().split(sep, QString::SkipEmptyParts,
		Qt::CaseInsensitive);

	for (it = list.constBegin(); it != list.constEnd(); ++it) {
		val = it->split(sep2, QString::SkipEmptyParts,
			Qt::CaseInsensitive);
		btn = new QCheckBox(val.at(0).trimmed(), box);
		btn->setMinimumHeight(btn->fontMetrics().lineSpacing());
		connect(btn, SIGNAL(clicked()), this, SLOT(changed()));
		vbox->addWidget(btn);
		map.insert(btn->text(), btn);
	}

	setDefaultValue(tosw->value());
	setDefault();
	saved_value.clear();
}


void
OptimizerSwitchEditor::setValue(const QString &val)
{
	QCheckBox	*btn;
	QStringList	sval(val.split(sep, QString::SkipEmptyParts,
				Qt::CaseInsensitive)),
			tmp;
	QString		name;
	QStringList::iterator	it;

	clear();

	for (it = sval.begin(); it != sval.end(); ++it) {
		tmp = it->split(sep2, QString::SkipEmptyParts,
			Qt::CaseInsensitive);
		name = tmp.at(0).trimmed();
		btn = map.value(name, NULL);
		if (btn == NULL)
			btn = scan(name);
		if (btn != NULL) {
			btn->setChecked(Core::string2bool(tmp.at(1)));
			curr_value<<QString("%1%2%3").arg(tmp.at(0)).arg(sep2)
				.arg(tmp.at(1).toLower());
		}
	}
	if (saved_value.isEmpty())
		saved_value = curr_value;
	setSaveEnabled(curr_value != saved_value);
}


void
OptimizerSwitchEditor::clear()
{
	SetMap::iterator	it;

	for (it = map.begin(); it != map.end(); ++it)
		(*it)->setChecked(FALSE);
	curr_value.clear();
}


QCheckBox *
OptimizerSwitchEditor::scan(const QString &val)const
{
	SetMap::const_iterator	it;
	QCheckBox		*tmp, *ret = NULL;

	for (it = map.constBegin(); it != map.constEnd(); ++it) {
		tmp = it.value();
		if (tmp->text().compare(val, Qt::CaseInsensitive) == 0) {
			ret = tmp;
			break;
		}
	}

	return (ret);
}


void
OptimizerSwitchEditor::changed()
{
	SetMap::const_iterator	it;
	QStringList		tmp;

	for (it = map.constBegin(); it != map.constEnd(); ++it)
		tmp<<QString("%1%2%3").arg(it.key()).arg(sep2)
			.arg(Core::bool2string((*it)->isChecked()).toLower());

	curr_value = tmp;
	setSaveEnabled(curr_value != saved_value);
}


void
OptimizerSwitchEditor::setDefault()
{

	setValue(defaultValue());
}


void
OptimizerSwitchEditor::commit(SqlConnection *conn, const QString &name)
{

	doCommit(conn, name, QString("'%1'").arg(curr_value.join(sep)));
}

/* EOF */
