/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: set_editor.cpp,v 1.1 2013/10/07 17:00:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "set_editor.h"
#include "sql_connection.h"
#include "sql_error.h"
#include "tunable_set.h"

static const QChar	sep(',');

/* FIXME:    "Default" */

SetEditor::SetEditor(QWidget *parent)
	:AbstractEditor(parent), curr_value(QStringList()),
	saved_value(QStringList())
{

	desc = new QLabel(this);
	desc->setAlignment(Qt::AlignLeft | Qt::AlignTop);
	desc->setWordWrap(TRUE);
	layout->addWidget(desc, 1);

	addDefaultValue();

	box = new QGroupBox(this);
	layout->addWidget(box);

	vbox = new QVBoxLayout(box);
	MARGINS_ZERO(vbox);

	addDialog();
}

SetEditor::~SetEditor()
{
	SetMap::iterator	it;
	QCheckBox		*btn;

	for (it = map.begin(); it != map.end(); ) {
		btn = *it;
		delete btn;
		it = map.erase(it);
	}

	delete vbox;
	delete box;
	delete desc;
}


void
SetEditor::setTemplate(const TunableVariable *var)
{
	const TunableSet		*tset;
	QCheckBox			*btn;
	EnumVector			vect;
	EnumVector::const_iterator	it;
	EnumItem			item;

	FATAL(var->type() != TunableVariable::T_SET);
	tset = static_cast<const TunableSet *>(var);
	desc->setText(var->description());
	vect = tset->vector();

	for (it = vect.constBegin(); it != vect.constEnd(); ++it) {
		item = *it;
		btn = new QCheckBox(item.second, box);
		btn->setMinimumHeight(btn->fontMetrics().lineSpacing());
		connect(btn, SIGNAL(clicked()), this, SLOT(changed()));
		vbox->addWidget(btn);
		map.insert(item.first, btn);
	}

	setDefaultValue(tset->value());
	setDefault();
	saved_value.clear();
}


void
SetEditor::setValue(const QString &val)
{
	QCheckBox	*btn;
	QStringList	sval(val.split(sep, QString::SkipEmptyParts,
				Qt::CaseInsensitive));
	QString		tmp;
	QStringList::iterator	it;

	clear();

	for (it = sval.begin(); it != sval.end(); ++it) {
		tmp = it->trimmed();
		btn = map.value(tmp, NULL);
		if (btn == NULL)
			btn = scan(tmp);
		if (btn != NULL) {
			btn->setChecked(TRUE);
			curr_value<<tmp;
		}
	}
	if (saved_value.isEmpty())
		saved_value = curr_value;
	setSaveEnabled(curr_value != saved_value);
}


void
SetEditor::clear()
{
	SetMap::iterator	it;

	for (it = map.begin(); it != map.end(); ++it)
		(*it)->setChecked(FALSE);
	curr_value.clear();
}


QCheckBox *
SetEditor::scan(const QString &val)const
{
	SetMap::const_iterator	it;
	QCheckBox		*tmp, *ret = NULL;

	for (it = map.constBegin(); it != map.constEnd(); ++it) {
		tmp = it.value();
		if (tmp->text().compare(val, Qt::CaseInsensitive) == 0) {
			ret = tmp;
			break;
		}
	}

	return (ret);
}


void
SetEditor::changed()
{
	SetMap::const_iterator	it;
	QStringList		tmp;

	for (it = map.constBegin(); it != map.constEnd(); ++it)
		if ((*it)->isChecked())
			tmp<<it.key();

	curr_value = tmp;
	setSaveEnabled(curr_value != saved_value);
}


void
SetEditor::setDefault()
{

	setValue(defaultValue());
}


void
SetEditor::commit(SqlConnection *conn, const QString &name)
{

	doCommit(conn, name, QString("'%1'").arg(curr_value.join(sep)));
}

/* EOF */
