/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: status.hpp,v 1.12 2013/10/08 14:38:35 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Initialization the map by known status variables
 * this procedure does not depend of a server version
 * the system will not show unused variables,
 * but it _must_ present here
 */

#define	ADD_STATUS(v_name, v_desc)	do {				\
	AbstractVariable	*tmp;					\
	tmp = new StatusVariable(v_name, v_desc);			\
	map->insert(tmp->name(), tmp);					\
} while (0)

#define	ADD_STATUS_CMD(v_name, v_cmd, v_desc)	do {			\
	StatusVariable	*tmp;					\
	tmp = new StatusVariable(v_name, v_desc);			\
	tmp->setCommandLine(v_cmd);					\
	map->insert(tmp->name(), tmp);					\
} while (0)



static void
initStatus(VariableMap *map)
{
	QString	com(QObject::tr("Number of <b>%1</b> commands executed"));

#include "aborted_clients.hpp"
#include "aborted_connects.hpp"
#include "access_denied_errors.hpp"

#include "aria_block_size.hpp"
#include "aria_group_commit.hpp"
#include "aria_group_commit_interval.hpp"
#include "aria_force_start_after_recovery_failures.hpp"
#include "aria_pagecache_blocks_not_flushed.hpp"
#include "aria_pagecache_blocks_unused.hpp"
#include "aria_pagecache_blocks_used.hpp"
#include "aria_pagecache_buffer_size.hpp"
#include "aria_pagecache_read_requests.hpp"
#include "aria_pagecache_reads.hpp"
#include "aria_pagecache_write_requests.hpp"
#include "aria_pagecache_writes.hpp"
#include "aria_transaction_log_syncs.hpp"
#include "aria_used_for_temp_tables.hpp"

#include "back_log.hpp"
#include "basedir.hpp"

#include "binlog_bytes_written.hpp"
#include "binlog_cache_disk_use.hpp"
#include "binlog_cache_use.hpp"
#include "binlog_commits.hpp"
#include "binlog_group_commits.hpp"
#include "binlog_optimize_thread_scheduling.hpp"
#include "binlog_snapshot_file.hpp"
#include "binlog_snapshot_position.hpp"
#include "binlog_stmt_cache_disk_use.hpp"
#include "binlog_stmt_cache_use.hpp"

#include "busy_time.hpp"

#include "bytes_received.hpp"
#include "bytes_sent.hpp"

#include "character_set_system.hpp"
#include "character_sets_dir.hpp"

#include "com_admin_commands.hpp"
#include "com_assign_to_keycache.hpp"
#include "com_alter_db.hpp"
#include "com_alter_db_upgrade.hpp"
#include "com_alter_event.hpp"
#include "com_alter_function.hpp"
#include "com_alter_procedure.hpp"
#include "com_alter_server.hpp"
#include "com_alter_table.hpp"
#include "com_alter_tablespace.hpp"
#include "com_analyze.hpp"
#include "com_assign_to_keycache.hpp"
#include "com_backup_table.hpp"
#include "com_begin.hpp"
#include "com_binlog.hpp"
#include "com_call_procedure.hpp"
#include "com_change_db.hpp"
#include "com_change_master.hpp"
#include "com_check.hpp"
#include "com_checksum.hpp"
#include "com_commit.hpp"
#include "com_create_db.hpp"
#include "com_create_event.hpp"
#include "com_create_function.hpp"
#include "com_create_index.hpp"
#include "com_create_procedure.hpp"
#include "com_create_server.hpp"
#include "com_create_table.hpp"
#include "com_create_trigger.hpp"
#include "com_create_udf.hpp"
#include "com_create_user.hpp"
#include "com_create_view.hpp"
#include "com_dealloc_sql.hpp"
#include "com_delete.hpp"
#include "com_delete_multi.hpp"
#include "com_do.hpp"
#include "com_drop_db.hpp"
#include "com_drop_event.hpp"
#include "com_drop_function.hpp"
#include "com_drop_index.hpp"
#include "com_drop_procedure.hpp"
#include "com_drop_server.hpp"
#include "com_drop_table.hpp"
#include "com_drop_trigger.hpp"
#include "com_drop_user.hpp"
#include "com_drop_view.hpp"
#include "com_empty_query.hpp"
#include "com_execute_sql.hpp"
#include "com_flush.hpp"
#include "com_grant.hpp"
#include "com_ha_close.hpp"
#include "com_ha_open.hpp"
#include "com_ha_read.hpp"
#include "com_help.hpp"
#include "com_insert.hpp"
#include "com_insert_select.hpp"
#include "com_install_plugin.hpp"
#include "com_kill.hpp"
#include "com_load.hpp"
#include "com_load_master_data.hpp"
#include "com_load_master_table.hpp"
#include "com_lock_tables.hpp"
#include "com_optimize.hpp"
#include "com_preload_keys.hpp"
#include "com_prepare.hpp"
#include "com_prepare_sql.hpp"
#include "com_purge.hpp"
#include "com_purge_before_date.hpp"
#include "com_release_savepoint.hpp"
#include "com_rename_table.hpp"
#include "com_rename_user.hpp"
#include "com_repair.hpp"
#include "com_replace.hpp"
#include "com_replace_select.hpp"
#include "com_reset.hpp"
#include "com_resignal.hpp"
#include "com_revoke.hpp"
#include "com_revoke_all.hpp"
#include "com_rollback.hpp"
#include "com_rollback_to_savepoint.hpp"
#include "com_savepoint.hpp"
#include "com_select.hpp"
#include "com_set_option.hpp"
#include "com_show_authors.hpp"
#include "com_show_binlog_events.hpp"
#include "com_show_binlogs.hpp"
#include "com_show_charsets.hpp"
#include "com_show_client_statistics.hpp"
#include "com_show_collations.hpp"
#include "com_show_contributors.hpp"
#include "com_show_create_db.hpp"
#include "com_show_create_event.hpp"
#include "com_show_create_func.hpp"
#include "com_show_create_proc.hpp"
#include "com_show_create_table.hpp"
#include "com_show_create_trigger.hpp"
#include "com_show_databases.hpp"
#include "com_show_engine_logs.hpp"
#include "com_show_engine_mutex.hpp"
#include "com_show_engine_status.hpp"
#include "com_show_errors.hpp"
#include "com_show_events.hpp"
#include "com_show_explain.hpp"
#include "com_show_fields.hpp"
#include "com_show_function_code.hpp"
#include "com_show_function_status.hpp"
#include "com_show_grants.hpp"
#include "com_show_index_statistics.hpp"
#include "com_show_keys.hpp"
#include "com_show_master_status.hpp"
#include "com_show_open_tables.hpp"
#include "com_show_plugins.hpp"
#include "com_show_privileges.hpp"
#include "com_show_procedure_code.hpp"
#include "com_show_procedure_status.hpp"
#include "com_show_processlist.hpp"
#include "com_show_profile.hpp"
#include "com_show_profiles.hpp"
#include "com_show_relaylog_events.hpp"
#include "com_show_slave_hosts.hpp"
#include "com_show_slave_status.hpp"
#include "com_show_status.hpp"
#include "com_show_storage_engines.hpp"
#include "com_show_table_statistics.hpp"
#include "com_show_table_status.hpp"
#include "com_show_tables.hpp"
#include "com_show_triggers.hpp"
#include "com_show_user_statistics.hpp"
#include "com_show_variables.hpp"
#include "com_show_warnings.hpp"
#include "com_signal.hpp"
#include "com_slave_start.hpp"
#include "com_slave_stop.hpp"
#include "com_start_all_slaves.hpp"
#include "com_start_slave.hpp"
#include "com_stmt_close.hpp"
#include "com_stmt_execute.hpp"
#include "com_stmt_fetch.hpp"
#include "com_stmt_prepare.hpp"
#include "com_stmt_reprepare.hpp"
#include "com_stmt_reset.hpp"
#include "com_stmt_send_long_data.hpp"
#include "com_stop_all_slaves.hpp"
#include "com_stop_slave.hpp"
#include "com_truncate.hpp"
#include "com_uninstall_plugin.hpp"
#include "com_unlock_tables.hpp"
#include "com_update.hpp"
#include "com_update_multi.hpp"
#include "com_xa_commit.hpp"
#include "com_xa_end.hpp"
#include "com_xa_prepare.hpp"
#include "com_xa_recover.hpp"
#include "com_xa_rollback.hpp"
#include "com_xa_start.hpp"

#include "compression.hpp"

#include "connections.hpp"

#include "cpu_time.hpp"

#include "created_tmp_disk_tables.hpp"
#include "created_tmp_files.hpp"
#include "created_tmp_tables.hpp"

#include "datadir.hpp"

#include "datetime_format.hpp"
#include "date_format.hpp"

#include "debug_no_thread_alarm.hpp"

#include "delayed_errors.hpp"
#include "delayed_insert_threads.hpp"
#include "delayed_writes.hpp"

#include "empty_queries.hpp"

#include "executed_events.hpp"
#include "executed_triggers.hpp"

#include "extra_port.hpp"

#include "feature_dynamic_columns.hpp"
#include "feature_fulltext.hpp"
#include "feature_gis.hpp"
#include "feature_locale.hpp"
#include "feature_subquery.hpp"
#include "feature_timezone.hpp"
#include "feature_trigger.hpp"
#include "feature_xml.hpp"

#include "flush_commands.hpp"

#include "ft_max_word_len.hpp"
#include "ft_min_word_len.hpp"
#include "ft_query_expansion_limit.hpp"
#include "ft_stopword_file.hpp"

#include "gtid_binlog_pos.hpp"
#include "gtid_current_pos.hpp"

#include "handler_commit.hpp"
#include "handler_delete.hpp"
#include "handler_discover.hpp"
#include "handler_external_lock.hpp"
#include "handler_icp_attempts.hpp"
#include "handler_icp_match.hpp"
#include "handler_mrr_init.hpp"
#include "handler_mrr_key_refills.hpp"
#include "handler_mrr_rowid_refills.hpp"
#include "handler_prepare.hpp"
#include "handler_read_first.hpp"
#include "handler_read_key.hpp"
#include "handler_read_last.hpp"
#include "handler_read_next.hpp"
#include "handler_read_prev.hpp"
#include "handler_read_rnd.hpp"
#include "handler_read_rnd_deleted.hpp"
#include "handler_read_rnd_next.hpp"
#include "handler_rollback.hpp"
#include "handler_savepoint.hpp"
#include "handler_savepoint_rollback.hpp"
#include "handler_tmp_update.hpp"
#include "handler_tmp_write.hpp"
#include "handler_update.hpp"
#include "handler_write.hpp"

#include "have_compress.hpp"
#include "have_crypt.hpp"
#include "have_csv.hpp"
#include "have_dynamic_loading.hpp"
#include "have_geometry.hpp"
#include "have_innodb.hpp"
#include "have_ndbcluster.hpp"
#include "have_openssl.hpp"
#include "have_partitioning.hpp"
#include "have_profiling.hpp"
#include "have_query_cache.hpp"
#include "have_rtree_keys.hpp"
#include "have_ssl.hpp"
#include "have_symlink.hpp"
#include "hostname.hpp"

#include "ignore_builtin_innodb.hpp"
#include "ignore_db_dirs.hpp"
#include "init_file.hpp"

#include "innodb_adaptive_hash_cells.hpp"
#include "innodb_adaptive_hash_heap_buffers.hpp"
#include "innodb_adaptive_hash_hash_searches.hpp"
#include "innodb_adaptive_hash_index_partitions.hpp"
#include "innodb_adaptive_hash_non_hash_searches.hpp"
#include "innodb_additional_mem_pool_size.hpp"
#include "innodb_available_undo_logs.hpp"
#include "innodb_autoinc_lock_mode.hpp"
#include "innodb_background_log_sync.hpp"
#include "innodb_blocking_buffer_pool_restore.hpp"
#include "innodb_buffer_pool_bytes_data.hpp"
#include "innodb_buffer_pool_bytes_dirty.hpp"
#include "innodb_buffer_pool_dump_status.hpp"
#include "innodb_buffer_pool_instances.hpp"
#include "innodb_buffer_pool_load_at_startup.hpp"
#include "innodb_buffer_pool_load_status.hpp"
#include "innodb_buffer_pool_pages_data.hpp"
#include "innodb_buffer_pool_pages_dirty.hpp"
#include "innodb_buffer_pool_pages_flushed.hpp"
#include "innodb_buffer_pool_pages_lru_flushed.hpp"
#include "innodb_buffer_pool_pages_free.hpp"
#include "innodb_buffer_pool_pages_made_not_young.hpp"
#include "innodb_buffer_pool_pages_made_young.hpp"
#include "innodb_buffer_pool_pages_misc.hpp"
#include "innodb_buffer_pool_pages_old.hpp"
#include "innodb_buffer_pool_pages_total.hpp"
#include "innodb_buffer_pool_populate.hpp"
#include "innodb_buffer_pool_read_ahead_rnd.hpp"
#include "innodb_buffer_pool_read_ahead.hpp"
#include "innodb_buffer_pool_read_ahead_evicted.hpp"
#include "innodb_buffer_pool_read_requests.hpp"
#include "innodb_buffer_pool_reads.hpp"
#include "innodb_buffer_pool_shm_checksum.hpp"
#include "innodb_buffer_pool_shm_key.hpp"
#include "innodb_buffer_pool_size.hpp"
#include "innodb_buffer_pool_wait_free.hpp"
#include "innodb_buffer_pool_write_requests.hpp"
#include "innodb_checkpoint_age.hpp"
#include "innodb_checkpoint_max_age.hpp"
#include "innodb_checkpoint_target_age.hpp"
#include "innodb_checksums.hpp"
#include "innodb_current_row_locks.hpp"
#include "innodb_data_file_path.hpp"
#include "innodb_data_fsyncs.hpp"
#include "innodb_data_home_dir.hpp"
#include "innodb_data_pending_fsyncs.hpp"
#include "innodb_data_pending_reads.hpp"
#include "innodb_data_pending_writes.hpp"
#include "innodb_data_read.hpp"
#include "innodb_data_reads.hpp"
#include "innodb_data_writes.hpp"
#include "innodb_data_written.hpp"
#include "innodb_dblwr_pages_written.hpp"
#include "innodb_dblwr_writes.hpp"
#include "innodb_deadlocks.hpp"
#include "innodb_dict_tables.hpp"
#include "innodb_doublewrite.hpp"
#include "innodb_doublewrite_file.hpp"
#include "innodb_extra_rsegments.hpp"
#include "innodb_extra_undoslots.hpp"
#include "innodb_fast_checksum.hpp"
#include "innodb_file_format_check.hpp"
#include "innodb_flush_method.hpp"
#include "innodb_force_load_corrupted.hpp"
#include "innodb_force_recovery.hpp"
#include "innodb_ft_cache_size.hpp"
#include "innodb_ft_max_token_size.hpp"
#include "innodb_ft_min_token_size.hpp"
#include "innodb_ft_sort_pll_degree.hpp"
#include "innodb_have_atomic_builtins.hpp"
#include "innodb_history_list_length.hpp"
#include "innodb_ibuf_discarded_delete_marks.hpp"
#include "innodb_ibuf_discarded_deletes.hpp"
#include "innodb_ibuf_discarded_inserts.hpp"
#include "innodb_ibuf_free_list.hpp"
#include "innodb_ibuf_max_size.hpp"
#include "innodb_ibuf_merged_delete_marks.hpp"
#include "innodb_ibuf_merged_deletes.hpp"
#include "innodb_ibuf_merged_inserts.hpp"
#include "innodb_ibuf_merges.hpp"
#include "innodb_ibuf_segment_size.hpp"
#include "innodb_ibuf_size.hpp"
#include "innodb_log_block_size.hpp"
#include "innodb_log_buffer_size.hpp"
#include "innodb_log_file_size.hpp"
#include "innodb_log_files_in_group.hpp"
#include "innodb_log_group_home_dir.hpp"
#include "innodb_log_waits.hpp"
#include "innodb_log_write_requests.hpp"
#include "innodb_log_writes.hpp"
#include "innodb_lsn_current.hpp"
#include "innodb_lsn_flushed.hpp"
#include "innodb_lsn_last_checkpoint.hpp"
#include "innodb_master_thread_1_second_loops.hpp"
#include "innodb_master_thread_10_second_loops.hpp"
#include "innodb_master_thread_background_loops.hpp"
#include "innodb_master_thread_main_flush_loops.hpp"
#include "innodb_master_thread_sleeps.hpp"
#include "innodb_max_dirty_pages_pct.hpp"
#include "innodb_max_trx_id.hpp"
#include "innodb_mem_adaptive_hash.hpp"
#include "innodb_mem_dictionary.hpp"
#include "innodb_mem_total.hpp"
#include "innodb_mirrored_log_groups.hpp"
#include "innodb_mutex_os_waits.hpp"
#include "innodb_mutex_spin_rounds.hpp"
#include "innodb_mutex_spin_waits.hpp"
#include "innodb_num_open_files.hpp"
#include "innodb_open_files.hpp"
#include "innodb_oldest_view_low_limit_trx_id.hpp"
#include "innodb_os_log_fsyncs.hpp"
#include "innodb_os_log_pending_fsyncs.hpp"
#include "innodb_os_log_pending_writes.hpp"
#include "innodb_os_log_written.hpp"
#include "innodb_page_size.hpp"
#include "innodb_pages_created.hpp"
#include "innodb_pages_read.hpp"
#include "innodb_pages_written.hpp"
#include "innodb_purge_batch_size.hpp"
#include "innodb_purge_threads.hpp"
#include "innodb_purge_trx_id.hpp"
#include "innodb_purge_undo_no.hpp"
#include "innodb_read_io_threads.hpp"
#include "innodb_recovery_stats.hpp"
#include "innodb_recovery_update_relay_log.hpp"
#include "innodb_rollback_on_timeout.hpp"
#include "innodb_row_lock_current_waits.hpp"
#include "innodb_row_lock_numbers.hpp"
#include "innodb_row_lock_time.hpp"
#include "innodb_row_lock_time_avg.hpp"
#include "innodb_row_lock_time_max.hpp"
#include "innodb_row_lock_time_waits.hpp"
#include "innodb_row_lock_waits.hpp"
#include "innodb_rows_deleted.hpp"
#include "innodb_rows_inserted.hpp"
#include "innodb_rows_read.hpp"
#include "innodb_rows_updated.hpp"
#include "innodb_s_lock_os_waits.hpp"
#include "innodb_s_lock_spin_rounds.hpp"
#include "innodb_s_lock_spin_waits.hpp"
#include "innodb_sort_buffer_size.hpp"
#include "innodb_sync_array_size.hpp"
#include "innodb_thread_concurrency_timer_based.hpp"
#include "innodb_track_changed_pages.hpp"
#include "innodb_truncated_status_writes.hpp"
#include "innodb_undo_directory.hpp"
#include "innodb_undo_logs.hpp"
#include "innodb_undo_tablespaces.hpp"
#include "innodb_use_atomic_writes.hpp"
#include "innodb_use_fallocate.hpp"
#include "innodb_use_native_aio.hpp"
#include "innodb_use_purge_thread.hpp"
#include "innodb_use_sys_malloc.hpp"
#include "innodb_use_sys_stats_table.hpp"
#include "innodb_version.hpp"
#include "innodb_write_io_threads.hpp"
#include "innodb_x_lock_os_waits.hpp"
#include "innodb_x_lock_spin_rounds.hpp"
#include "innodb_x_lock_spin_waits.hpp"

#include "key_blocks_not_flushed.hpp"
#include "key_blocks_unused.hpp"
#include "key_blocks_used.hpp"
#include "key_blocks_warm.hpp"
#include "key_read_requests.hpp"
#include "key_reads.hpp"
#include "key_write_requests.hpp"
#include "key_writes.hpp"

#include "language.hpp"
#include "large_files_support.hpp"
#include "large_page_size.hpp"
#include "large_pages.hpp"
#include "last_query_cost.hpp"
#include "lc_messages_dir.hpp"
#include "license.hpp"
#include "locked_in_memory.hpp"
#include "log_bin.hpp"
#include "log_error.hpp"
#include "log_slave_updates.hpp"
#include "lower_case_file_system.hpp"
#include "lower_case_table_names.hpp"

#include "max_long_data_size.hpp"
#include "max_write_lock_count.hpp"
#include "max_used_connections.hpp"
#include "memory_used.hpp"
#include "metadata_locks_cache_size.hpp"
#include "myisam_block_size.hpp"
#include "myisam_recover_options.hpp"

#include "not_flushed_delayed_rows.hpp"

#include "old.hpp"
#include "open_files.hpp"
#include "open_files_limit.hpp"
#include "open_streams.hpp"
#include "open_table_definitions.hpp"
#include "open_tables.hpp"
#include "opened_files.hpp"
#include "opened_plugin_libraries.hpp"
#include "opened_table_definitions.hpp"
#include "opened_tables.hpp"
#include "opened_views.hpp"

#include "performance_schema.hpp"
#include "performance_schema_accounts_lost.hpp"
#include "performance_schema_accounts_size.hpp"
#include "performance_schema_cond_classes_lost.hpp"
#include "performance_schema_cond_instances_lost.hpp"
#include "performance_schema_digest_lost.hpp"
#include "performance_schema_digests_size.hpp"
#include "performance_schema_events_stages_history_long_size.hpp"
#include "performance_schema_events_stages_history_size.hpp"
#include "performance_schema_events_statements_history_long_size.hpp"
#include "performance_schema_events_statements_history_size.hpp"
#include "performance_schema_events_waits_history_long_size.hpp"
#include "performance_schema_events_waits_history_size.hpp"
#include "performance_schema_file_classes_lost.hpp"
#include "performance_schema_file_handles_lost.hpp"
#include "performance_schema_file_instances_lost.hpp"
#include "performance_schema_hosts_lost.hpp"
#include "performance_schema_hosts_size.hpp"
#include "performance_schema_locker_lost.hpp"
#include "performance_schema_max_cond_classes.hpp"
#include "performance_schema_max_cond_instances.hpp"
#include "performance_schema_max_file_classes.hpp"
#include "performance_schema_max_file_handles.hpp"
#include "performance_schema_max_file_instances.hpp"
#include "performance_schema_max_mutex_classes.hpp"
#include "performance_schema_max_mutex_instances.hpp"
#include "performance_schema_max_rwlock_classes.hpp"
#include "performance_schema_max_rwlock_instances.hpp"
#include "performance_schema_max_socket_classes.hpp"
#include "performance_schema_max_socket_instances.hpp"
#include "performance_schema_max_stage_classes.hpp"
#include "performance_schema_max_statement_classes.hpp"
#include "performance_schema_max_table_handles.hpp"
#include "performance_schema_max_table_instances.hpp"
#include "performance_schema_max_thread_classes.hpp"
#include "performance_schema_max_thread_instances.hpp"
#include "performance_schema_mutex_classes_lost.hpp"
#include "performance_schema_mutex_instances_lost.hpp"
#include "performance_schema_rwlock_classes_lost.hpp"
#include "performance_schema_rwlock_instances_lost.hpp"
#include "performance_schema_setup_actors_size.hpp"
#include "performance_schema_setup_objects_size.hpp"
#include "performance_schema_socket_classes_lost.hpp"
#include "performance_schema_socket_instances_lost.hpp"
#include "performance_schema_stage_classes_lost.hpp"
#include "performance_schema_statement_classes_lost.hpp"
#include "performance_schema_table_handles_lost.hpp"
#include "performance_schema_table_instances_lost.hpp"
#include "performance_schema_thread_classes_lost.hpp"
#include "performance_schema_thread_instances_lost.hpp"
#include "performance_schema_users_lost.hpp"
#include "performance_schema_users_size.hpp"

#include "pid_file.hpp"
#include "plugin_dir.hpp"
#include "plugin_maturity.hpp"
#include "port.hpp"
#include "prepared_stmt_count.hpp"
#include "protocol_version.hpp"

#include "qcache_free_blocks.hpp"
#include "qcache_free_memory.hpp"
#include "qcache_hits.hpp"
#include "qcache_inserts.hpp"
#include "qcache_lowmem_prunes.hpp"
#include "qcache_not_cached.hpp"
#include "qcache_queries_in_cache.hpp"
#include "qcache_total_blocks.hpp"

#include "queries.hpp"
#include "questions.hpp"

#include "relay_log.hpp"
#include "relay_log_index.hpp"
#include "relay_log_info_file.hpp"
#include "relay_log_space_limit.hpp"
#include "replicate_annotate_row_events.hpp"
#include "report_host.hpp"
#include "report_password.hpp"
#include "report_port.hpp"
#include "report_user.hpp"
#include "rows_read.hpp"
#include "rows_sent.hpp"
#include "rows_tmp_read.hpp"

#include "rpl_recovery_rank.hpp"
#include "rpl_status.hpp"

#include "secure_file_priv.hpp"

#include "select_full_join.hpp"
#include "select_full_range_join.hpp"
#include "select_range.hpp"
#include "select_range_check.hpp"
#include "select_scan.hpp"

#include "shared_memory.hpp"
#include "shared_memory_base_name.hpp"

#include "skip_external_locking.hpp"
#include "skip_name_resolve.hpp"
#include "skip_networking.hpp"
#include "skip_show_database.hpp"

#include "slave_heartbeat_period.hpp"
#include "slave_load_tmpdir.hpp"
#include "slave_open_temp_tables.hpp"
#include "slave_received_heartbeats.hpp"
#include "slave_retried_transactions.hpp"
#include "slave_running.hpp"
#include "slave_skip_errors.hpp"
#include "slave_type_conversions.hpp"

#include "slow_launch_threads.hpp"
#include "slow_queries.hpp"

#include "socket.hpp"

#include "sort_merge_passes.hpp"
#include "sort_range.hpp"
#include "sort_rows.hpp"
#include "sort_scan.hpp"

#include "sphinx_error.hpp"

#include "ssl_accept_renegotiates.hpp"
#include "ssl_accepts.hpp"
#include "ssl_ca.hpp"
#include "ssl_callback_cache_hits.hpp"
#include "ssl_capath.hpp"
#include "ssl_cert.hpp"
#include "ssl_cipher.hpp"
#include "ssl_cipher_list.hpp"
#include "ssl_client_connects.hpp"
#include "ssl_connect_renegotiates.hpp"
#include "ssl_crl.hpp"
#include "ssl_crlpath.hpp"
#include "ssl_ctx_verify_depth.hpp"
#include "ssl_ctx_verify_mode.hpp"
#include "ssl_default_timeout.hpp"
#include "ssl_finished_accepts.hpp"
#include "ssl_finished_connects.hpp"
#include "ssl_key.hpp"
#include "ssl_server_not_after.hpp"
#include "ssl_server_not_before.hpp"
#include "ssl_session_cache_hits.hpp"
#include "ssl_session_cache_misses.hpp"
#include "ssl_session_cache_mode.hpp"
#include "ssl_session_cache_overflows.hpp"
#include "ssl_session_cache_size.hpp"
#include "ssl_session_cache_timeouts.hpp"
#include "ssl_sessions_reused.hpp"
#include "ssl_used_session_cache_entries.hpp"
#include "ssl_verify_depth.hpp"
#include "ssl_verify_mode.hpp"
#include "ssl_version.hpp"

#include "storage_engine.hpp"

#include "subquery_cache_hit.hpp"
#include "subquery_cache_miss.hpp"

#include "syncs.hpp"
#include "system_time_zone.hpp"

#include "table_locks_immediate.hpp"
#include "table_locks_waited.hpp"

#include "tc_log_max_pages_used.hpp"
#include "tc_log_page_size.hpp"
#include "tc_log_page_waits.hpp"

#include "threadpool_idle_threads.hpp"
#include "threadpool_threads.hpp"

#include "threads_cached.hpp"
#include "thread_concurrency.hpp"
#include "threads_connected.hpp"
#include "threads_created.hpp"
#include "thread_handling.hpp"
#include "thread_pool_algorithm.hpp"
#include "thread_pool_size.hpp"
#include "threads_running.hpp"
#include "thread_stack.hpp"

#include "time_format.hpp"

#include "tmpdir.hpp"

#include "uptime.hpp"
#include "uptime_since_flush_status.hpp"

#include "version.hpp"
#include "version_comment.hpp"
#include "version_compile_machine.hpp"
#include "version_compile_os.hpp"

	/* End of function initStatus() */
}

/* EOF */
