/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: aria_group_commit.hpp,v 1.1 2013/09/26 13:39:15 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

ADD_STATUS_CMD("aria_group_commit",
	QStringList()<<"--aria_group_commit", QObject::tr(
"Specifies aria group commit mode."
"<ul>"
"<li><b>none</b> - Group commit is disabled."
"<li><b>hard</b> - Wait the number of microseconds specified by "
"aria_group_commit_interval before actually doing the commit. If the interval "
"is 0 then just check if any other threads have requested a commit during the "
"time this commit was preparing (just before sync() file) and send their data "
"to disk also before sync()."
"<li><b>soft</b> - The service thread will wait the specified time and then "
"sync() to the log. If the interval is 0 then it won't wait for any commits "
"(this is dangerous and should generally not be used in production)"
"</ul>"
));

/* EOF */
