/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: binlog_snapshot_file.hpp,v 1.1 2013/09/26 13:39:16 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

ADD_STATUS("binlog_snapshot_file", QObject::tr(
"<b>binlog_snapshot_file</b> and <b>binlog_snapshot_position</b> give the "
"binary log file and position like <b>SHOW MASTER STATUS</b> does. But they "
"can be queried in a transactionally consistent way. After starting a "
"transaction using <b>START TRANSACTION WITH CONSISTENT SNAPSHOT</b>, the two "
"variables will give the binlog position corresponding to the state of the "
"database of the consistent snapshot so taken, irrespectively of which other "
"transactions have been committed since the snapshot was taken (<b>SHOW MASTER "
"STATUS</b> always shows the position of the last committed transaction). This "
"works for MVCC storage engines that implement the commit ordering part of the "
"storage engine API, which at the time of writing is <b>XtraDB</b> and "
"<b>PBXT</b>"
"<p>"
"This is useful to obtain a logical dump/backup with a matching binlog "
"position that can be used to provision a new slave with the original server "
"as the master. First <b>START TRANSACTION WITH CONSISTENT SNAPSHOT</b> is "
"executed. Then a consistent state of the database is obtained with queries, "
"and the matching binlog position is obtained with <b>SHOW STATUS LIKE "
"'binlog_snapshot%'</b>. When this is loaded on a new slave server, the "
"binlog position is used in a <b>CHANGE MASTER TO</b> statement to set the "
"slave replicating from the correct position."
"<p>"
"With the variables binlog_snapshot_file and binlog_snapshot_position, such "
"provisioning can be done fully non-blocking on the master. Without them, is "
"is necessary to get the binlog position under <b>FLUSH TABLES WITH READ "
"LOCK;</b> this can stall the server for a potentially long time, as it "
"blocks new queries until all already started updates have finished"
));

/* EOF */
