/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: gtid_current_pos.hpp,v 1.1 2013/10/04 11:59:02 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

ADD_STATUS("gtid_current_pos", QObject::tr(
"This variable is the GTID of the last change to the database for each "
"replication domain. Such changes can either be master events (ie. local "
"changes made by user or application), or replicated events originating from "
"another master server."
"<p>"
"For each replication domain, if the server ID of the corresponding GTID in "
"@@gtid_binlog_pos is equal to the servers own server_id, and the sequence "
"number is higher than the corresponding GTID in @@gtid_slave_position, then "
"the GTID from @@gtid_binlog_pos will be used. Otherwise the GTID from "
"@@gtid_slave_position will be used for that domain."
"<p>"
"Thus, @@gtid_current_position contains the most recent GTID executed on the "
"server, whether this was done as a master or as a slave. This value is used "
"as the starting point of replication when a slave is configured with CHANGE "
"MASTER TO master_use_gtid=current_pos."
"<p>"
"The value is read-only, but it is updated whenever a DML or DDL statement is "
"written to the binary log and/or replicated by a slave thread"
));

/* EOF */
