/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_flush_method.hpp,v 1.1 2013/10/05 14:11:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

ADD_STATUS_CMD("innodb_flush_method",
	QStringList()<<"--innodb_flush_method", QObject::tr(
"XtraDB/InnoDB flushing method. Windows always uses async_unbuffered and this "
"variable then has no effect. On Unix, by default fsync() is used to flush "
"data and logs. If set to <b>O_DSYNC</b>, O_DSYNC is used to open and flush "
"logs, and fsync() to flush the data files. If set to <b>O_DIRECT</b>, "
"O_DIRECT or directio(), is used to open data files, and fsync() to flush data "
"and logs. Adjusting this can give performance improvements, but changing from "
"the default has also caused problems in some situations, so test and "
"benchmark carefully before adjusting. <b>fdatasync</b> is an old default "
"value that follows the default behavior of using fsync(), but it was replaced "
"with the unset default to avoid confusion between fdatasync() and fysnc()"
));

/* EOF */
