/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_sort_buffer_size.hpp,v 1.1 2013/10/08 14:38:36 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

ADD_STATUS("innodb_sort_buffer_size", QObject::tr(
"Specifies the size of sort buffers used for sorting data during creation of "
"an <b>InnoDB</b> index. The size specified defines the amount of data filled "
"in memory for an internal sort and written out to disk, which can be "
"referred to as a «run». During the merge phase, pairs of buffers of the "
"specified size are «read in» and merged. The larger the setting, the fewer "
"«runs» and merges there are, which is important to understand from a tuning "
"perspective."
"<p>"
"This sort area is only used for merge sorts during index creation, not "
"during later index maintenance operations. Buffers are deallocated when "
"index creation completes."
"<p>"
"The value of this option also controls the amount by which the temporary log "
"file is extended, to record concurrent DML during online DDL operations."
"<p>"
"Before this setting was made configurable, the size was hardcoded to 1048576 "
"bytes (<b>1MB</b>), and that value remains the default."
"<p>"
"During an ALTER TABLE or CREATE TABLE statement that creates an index, 3 "
"buffers are allocated, each with a size defined by this option. "
"Additionally, auxiliary pointers are allocated to rows in the sort buffer so "
"that the sort can run on pointers (as opposed to moving rows during the sort "
"operation)"
));

/* EOF */
