/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: innodb_undo_tablespaces.hpp,v 1.1 2013/10/08 14:38:36 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

ADD_STATUS("innodb_undo_tablespaces", QObject::tr(
"The number of tablespace files that the undo logs are divided between, when "
"you use a non-zero innodb_undo_logs setting. By default, all the undo logs "
"are part of the system tablespace and the system tablespace will always "
"contain one undo tablespace in addition to those configured by "
"<b>innodb_undo_tablespaces</b>. Because the undo logs can become large during "
"long-running transactions, splitting the undo logs between multiple "
"tablespaces reduces the maximum size of any one tablespace. The tablespace "
"files are created in the location defined by innodb_undo_directory, with "
"names of the form <b>undo<i>N</i></b>, where <b>N</b> is a sequential series "
"of integers, including leading zeros. The default size of undo tablespaces "
"files is <b>10M</b>. The number of innodb_undo_tablespaces must be set prior "
"to initializing <b>InnoDB</b>. Attempting to restart <b>InnoDB</b> after "
"changing the number of innodb_undo_tablespaces will result in a failed start "
"with an error stating that InnoDB did not find the expected number of undo "
"tablespaces"
));

/* EOF */
