/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: myisam_recover_options.hpp,v 1.1 2013/10/07 17:00:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

ADD_STATUS_CMD("myisam_recover_options",
	QStringList()<<"--myisam-recover", QObject::tr(
"<b>MyISAM</b> recovery mode. Multiple options can be selected, "
"comma-delimited. Using no argument is equivalent to specifying "
"<b>DEFAULT</b>, while specifying \"\" is equivalent to <b>OFF</b>. If enabled "
"each time the server opens a <b>MyISAM</b> table, it checks whether it has "
"been marked as crashed, or wasn't closed properly. If so, mysqld will run a "
"check and then attempt to repair the table, writing to the error log "
"beforehand. Previously called myisam_recover, which is still a valid synonym."
"<ul>"
"<li><b>OFF</b>: The default as of MariaDB 5.5.3, no recovery."
"<li><b>BACKUP</b>: If the data file is changed while recovering, saves a "
"backup of the <b>.MYD</b> data file. <b>t.MYD</b> will be saved as "
"<b>t-datetime.BAK</b>."
"<li><b>BACKUP_ALL</b>: Same as BACKUP but also backs up the <b>.MYI</b> index "
"file. Added in MariaDB 5.1.51."
"<li><b>DEFAULT</b>: Recovers without backing up, forcing, or quick checking."
"<li><b>FORCE</b>: Runs the recovery even if it determines that more than one "
"row from the data file will be lost."
"<li><b>QUICK</b>: Does not check rows in the table if there are no delete "
"blocks"
"</ul>"
));

/* EOF */
